/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.stats.model;

import hudson.Util;
import hudson.model.Computer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jenkins.model.Jenkins;
import org.apache.commons.math3.stat.descriptive.rank.Percentile;
import org.joda.time.LocalDateTime;
import org.zeroturnaround.stats.model.RunStats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatsData {
    public static final long WEEK_IN_MS = 604800000L;
    public static final long DAY_IN_MS = 86400000L;
    public static final long HOUR_IN_MS = 3600000L;
    protected List<RunStats> runStats = new ArrayList<RunStats>();
    private transient List<RunStats> edenStats = new ArrayList<RunStats>();

    public List<RunStats> getAllWaitTimes() {
        return this.runStats;
    }

    public void addWaitTime(long waitTime) {
    }

    private List<RunStats> getEdenStats() {
        if (this.edenStats == null) {
            this.edenStats = new ArrayList<RunStats>();
        }
        return this.edenStats;
    }

    public void addToEdenSpace(RunStats runStat) {
        this.getEdenStats().add(runStat);
    }

    public void addToTenuredSpace(RunStats runStat) {
        this.runStats.add(runStat);
    }

    public long getSize() {
        return this.runStats.size();
    }

    public String getAge() {
        if (this.runStats.size() == 0) {
            return "0 days";
        }
        return Util.getPastTimeString((long)(System.currentTimeMillis() - this.runStats.get(0).getStarted()));
    }

    public RunStats popUnInitializedItem(String name) {
        Iterator<RunStats> ite = this.getEdenStats().iterator();
        while (ite.hasNext()) {
            RunStats stats = ite.next();
            if (!name.equals(stats.getProjectName()) || 0L != stats.getDuration() || -1L == stats.getTimeInQueue()) continue;
            ite.remove();
            return stats;
        }
        return null;
    }

    public RunStats getUnInitializedItem(int queueId) {
        for (int i = this.getEdenStats().size() - 1; i >= 0; --i) {
            RunStats stats = this.getEdenStats().get(i);
            if (queueId != stats.getQueueId()) continue;
            return stats;
        }
        return null;
    }

    public long getAvgWait() {
        long total = 0L;
        long num = 0L;
        for (RunStats stats : this.runStats) {
            total += stats.getTimeInQueue();
            ++num;
        }
        if (num > 0L) {
            return total / num;
        }
        return 0L;
    }

    public long getAvgWaitTrailingWeek() {
        long sevenDaysAgo = System.currentTimeMillis() - 604800000L;
        ArrayList<RunStats> copyRunStats = new ArrayList<RunStats>(this.runStats);
        long total = 0L;
        long num = 0L;
        for (int i = copyRunStats.size() - 1; i > -1; --i) {
            RunStats stats = (RunStats)copyRunStats.get(i);
            if (stats.getStarted() <= sevenDaysAgo) continue;
            total += stats.getTimeInQueue();
            ++num;
        }
        if (num > 0L) {
            return total / num;
        }
        return 0L;
    }

    public Map<String, Long> getAvgWaitPerNode() {
        HashMap<String, Long> rtrn = new HashMap<String, Long>();
        HashMap<String, Long> counts = new HashMap<String, Long>();
        for (RunStats runStats : this.runStats) {
            Long value = (Long)rtrn.get(runStats.getNodeName());
            value = value == null ? Long.valueOf(runStats.getTimeInQueue()) : Long.valueOf(value + runStats.getTimeInQueue());
            rtrn.put(runStats.getNodeName(), value);
            Long count = (Long)counts.get(runStats.getNodeName());
            if (count == null) {
                count = 1L;
            } else {
                Long l = count;
                Long l2 = count = Long.valueOf(count + 1L);
            }
            counts.put(runStats.getNodeName(), count);
        }
        for (Map.Entry entry : rtrn.entrySet()) {
            Long count = (Long)counts.get(entry.getKey());
            rtrn.put((String)entry.getKey(), (Long)entry.getValue() / count);
        }
        return rtrn;
    }

    public Map<String, Long> getAvgWaitPerNodeTrailingWeek() {
        long sevenDaysAgo = System.currentTimeMillis() - 604800000L;
        HashMap<String, Long> rtrn = new HashMap<String, Long>();
        HashMap<String, Long> counts = new HashMap<String, Long>();
        for (RunStats runStats : this.runStats) {
            if (runStats.getStarted() <= sevenDaysAgo) continue;
            Long value = (Long)rtrn.get(runStats.getNodeName());
            value = value == null ? Long.valueOf(runStats.getTimeInQueue()) : Long.valueOf(value + runStats.getTimeInQueue());
            rtrn.put(runStats.getNodeName(), value);
            Long count = (Long)counts.get(runStats.getNodeName());
            if (count == null) {
                count = 1L;
            } else {
                Long l = count;
                Long l2 = count = Long.valueOf(count + 1L);
            }
            counts.put(runStats.getNodeName(), count);
        }
        for (Map.Entry entry : rtrn.entrySet()) {
            Long count = (Long)counts.get(entry.getKey());
            rtrn.put((String)entry.getKey(), (Long)entry.getValue() / count);
        }
        return rtrn;
    }

    public long getAvgDuration() {
        long total = 0L;
        long num = 0L;
        for (RunStats stats : this.runStats) {
            total += stats.getDuration();
            ++num;
        }
        if (num > 0L) {
            return total / num;
        }
        return 0L;
    }

    public long getAvgDurationTrailingWeek() {
        long sevenDaysAgo = System.currentTimeMillis() - 604800000L;
        ArrayList<RunStats> copyRunStats = new ArrayList<RunStats>(this.runStats);
        long total = 0L;
        long num = 0L;
        for (int i = copyRunStats.size() - 1; i > -1; --i) {
            RunStats stats = (RunStats)copyRunStats.get(i);
            if (stats.getStarted() <= sevenDaysAgo) continue;
            total += stats.getDuration();
            ++num;
        }
        if (num > 0L) {
            return total / num;
        }
        return 0L;
    }

    public Map<String, Long> getAvgDurationPerNode() {
        HashMap<String, Long> rtrn = new HashMap<String, Long>();
        HashMap<String, Long> counts = new HashMap<String, Long>();
        for (RunStats runStats : this.runStats) {
            Long value = (Long)rtrn.get(runStats.getNodeName());
            value = value == null ? Long.valueOf(runStats.getDuration()) : Long.valueOf(value + runStats.getDuration());
            rtrn.put(runStats.getNodeName(), value);
            Long count = (Long)counts.get(runStats.getNodeName());
            if (count == null) {
                count = 1L;
            } else {
                Long l = count;
                Long l2 = count = Long.valueOf(count + 1L);
            }
            counts.put(runStats.getNodeName(), count);
        }
        for (Map.Entry entry : rtrn.entrySet()) {
            Long count = (Long)counts.get(entry.getKey());
            rtrn.put((String)entry.getKey(), (Long)entry.getValue() / count);
        }
        return rtrn;
    }

    public Map<String, Long> getAvgDurationPerNodeTrailingWeek() {
        long sevenDaysAgo = System.currentTimeMillis() - 604800000L;
        HashMap<String, Long> rtrn = new HashMap<String, Long>();
        HashMap<String, Long> counts = new HashMap<String, Long>();
        for (RunStats runStats : this.runStats) {
            if (runStats.getStarted() <= sevenDaysAgo) continue;
            Long value = (Long)rtrn.get(runStats.getNodeName());
            value = value == null ? Long.valueOf(runStats.getDuration()) : Long.valueOf(value + runStats.getDuration());
            rtrn.put(runStats.getNodeName(), value);
            Long count = (Long)counts.get(runStats.getNodeName());
            if (count == null) {
                count = 1L;
            } else {
                Long l = count;
                Long l2 = count = Long.valueOf(count + 1L);
            }
            counts.put(runStats.getNodeName(), count);
        }
        for (Map.Entry entry : rtrn.entrySet()) {
            Long count = (Long)counts.get(entry.getKey());
            rtrn.put((String)entry.getKey(), (Long)entry.getValue() / count);
        }
        return rtrn;
    }

    public long getAvgThroughputHour() {
        if (this.runStats.size() == 0) {
            return 0L;
        }
        long first = this.runStats.get(0).getStarted();
        long last = this.runStats.get(this.runStats.size() - 1).getStarted();
        long diff = last - first;
        long hours = diff / 3600000L;
        if (3600000L > diff) {
            return this.runStats.size();
        }
        return (long)this.runStats.size() / hours;
    }

    public long getAvgThroughputDay() {
        if (this.runStats.size() == 0) {
            return 0L;
        }
        long first = this.runStats.get(0).getStarted();
        long last = this.runStats.get(this.runStats.size() - 1).getStarted();
        long diff = last - first;
        long days = diff / 86400000L;
        if (86400000L > diff) {
            return this.runStats.size();
        }
        return (long)this.runStats.size() / days;
    }

    public long getAvgThroughputWeek() {
        if (this.runStats.size() == 0) {
            return 0L;
        }
        long first = this.runStats.get(0).getStarted();
        long last = this.runStats.get(this.runStats.size() - 1).getStarted();
        long diff = last - first;
        long weeks = diff / 604800000L;
        if (604800000L > diff) {
            return this.runStats.size();
        }
        return (long)this.runStats.size() / weeks;
    }

    private RunStats findFirstOfTrailingWeek() {
        long sevenDaysAgo = System.currentTimeMillis() - 604800000L;
        for (RunStats stat : this.runStats) {
            if (stat.getStarted() < sevenDaysAgo) continue;
            return stat;
        }
        return this.runStats.get(0);
    }

    private long getCountTrailingWeek() {
        long sevenDaysAgo = System.currentTimeMillis() - 604800000L;
        long rtrn = 0L;
        for (RunStats stat : this.runStats) {
            if (stat.getStarted() < sevenDaysAgo) continue;
            ++rtrn;
        }
        return rtrn;
    }

    public long getAvgThroughputHourTrailingWeek() {
        if (this.runStats.size() < 2) {
            return 0L;
        }
        long first = this.findFirstOfTrailingWeek().getStarted();
        long last = this.runStats.get(this.runStats.size() - 1).getStarted();
        long diff = last - first;
        long hours = diff / 3600000L;
        long trailingWeekCount = this.getCountTrailingWeek();
        if (3600000L > diff) {
            return trailingWeekCount;
        }
        return trailingWeekCount / hours;
    }

    public long getAvgThroughputDayTrailingWeek() {
        if (this.runStats.size() < 2) {
            return 0L;
        }
        long first = this.findFirstOfTrailingWeek().getStarted();
        long last = this.runStats.get(this.runStats.size() - 1).getStarted();
        long diff = last - first;
        long days = diff / 86400000L;
        long trailingWeekCount = this.getCountTrailingWeek();
        if (86400000L > diff) {
            return trailingWeekCount;
        }
        return trailingWeekCount / days;
    }

    public long getAvgThroughputWeekTrailingWeek() {
        if (this.runStats.size() < 2) {
            return 0L;
        }
        long trailingWeekCount = this.getCountTrailingWeek();
        return trailingWeekCount;
    }

    public long getDurationPercentile(long percentile) {
        double[] statsL = new double[this.runStats.size()];
        int i = 0;
        for (RunStats stats : this.runStats) {
            statsL[i++] = stats.getDuration();
        }
        Percentile perc = new Percentile();
        Arrays.sort(statsL);
        perc.setData(statsL);
        long rtrn = (long)perc.evaluate((double)percentile);
        return rtrn;
    }

    public long getWaitPercentile(long percentile) {
        double[] statsL = new double[this.runStats.size()];
        int i = 0;
        for (RunStats stats : this.runStats) {
            statsL[i++] = stats.getTimeInQueue();
        }
        Percentile perc = new Percentile();
        Arrays.sort(statsL);
        perc.setData(statsL);
        long rtrn = (long)perc.evaluate((double)percentile);
        return rtrn;
    }

    public Map<String, Long> getJobCountBreakdown() {
        HashMap<String, Long> nodeInfo = new HashMap<String, Long>();
        for (RunStats stats : this.runStats) {
            Long count = (Long)nodeInfo.get(stats.getNodeName());
            if (count == null) {
                count = 0L;
            }
            count = count + 1L;
            nodeInfo.put(stats.getNodeName(), count);
        }
        return nodeInfo;
    }

    public Map<String, Long> getJobCountBreakdownTrailingWeek() {
        long sevenDaysAgo = System.currentTimeMillis() - 604800000L;
        HashMap<String, Long> nodeInfo = new HashMap<String, Long>();
        for (RunStats stats : this.runStats) {
            if (stats.getStarted() < sevenDaysAgo) continue;
            Long count = (Long)nodeInfo.get(stats.getNodeName());
            if (count == null) {
                count = 0L;
            }
            count = count + 1L;
            nodeInfo.put(stats.getNodeName(), count);
        }
        return nodeInfo;
    }

    public Map<String, String> getClusterMetaInfo() {
        HashMap<String, String> clusterInfo = new HashMap<String, String>();
        Computer[] computers = Jenkins.getInstance().getComputers();
        for (int i = 0; i < computers.length; ++i) {
            Computer c = computers[i];
            Map env = null;
            try {
                env = c.getSystemProperties();
            }
            catch (IOException e) {
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            String osName = "Unknown";
            if (env.get("os.name") != null) {
                osName = (String)env.get("os.name");
            }
            clusterInfo.put(computers[i].getNode().getDisplayName(), c.countExecutors() + "," + osName);
        }
        return clusterInfo;
    }

    public Map<String, Long> getJobsMetaInfo() {
        HashMap<String, Long> jobInfo = new HashMap<String, Long>();
        for (RunStats stats : this.runStats) {
            Long count = (Long)jobInfo.get(stats.getProjectName());
            if (count == null) {
                count = 0L;
            }
            count = count + 1L;
            jobInfo.put(stats.getProjectName(), count);
        }
        return jobInfo;
    }

    public Map<String, Integer> getWeeklyThroughput() {
        HashMap<String, Integer> weeklyThroughput = new HashMap<String, Integer>();
        for (RunStats stats : this.runStats) {
            long started = stats.getStarted();
            LocalDateTime time = new LocalDateTime(started);
            int no = 0;
            String key = time.getWeekOfWeekyear() + "-" + (time.getWeekyear() + "").substring(2, 4);
            if (weeklyThroughput.get(key) != null) {
                no = (Integer)weeklyThroughput.get(key);
            }
            weeklyThroughput.put(key, ++no);
        }
        return new TreeMap<String, Integer>(weeklyThroughput);
    }

    public void deleteAllStatistics() {
        this.runStats = new ArrayList<RunStats>();
        this.edenStats = new ArrayList<RunStats>();
    }

    public void cleanUp(int dataSizeLimit) {
        if (this.runStats.size() > dataSizeLimit) {
            this.runStats = this.runStats.subList(this.runStats.size() - dataSizeLimit, this.runStats.size());
        }
    }
}

