/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.stats;

import hudson.Plugin;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.zeroturnaround.stats.model.StatsData;
import org.zeroturnaround.stats.util.ConvertXML;

public class ClusterStatisticsPlugin
extends Plugin {
    private StatsData statsData = new StatsData();
    private transient long lastSaved = 0L;
    public static final int DATA_SIZE_LIMIT = 150000;
    public static final int SOME_EXTRA = 10000;

    public StatsData getStatsData() {
        return this.statsData;
    }

    public void setStatsData(StatsData statsData) {
        this.statsData = statsData;
    }

    public static ClusterStatisticsPlugin getInstance() {
        return (ClusterStatisticsPlugin)Jenkins.getInstance().getPlugin(ClusterStatisticsPlugin.class);
    }

    public void start() throws Exception {
        super.start();
        this.load();
    }

    public void stop() throws Exception {
        super.stop();
        this.save();
    }

    public synchronized void maybeSave() throws IOException {
        long time = System.currentTimeMillis();
        if (this.lastSaved == 0L || time - this.lastSaved > 60000L) {
            super.save();
            this.lastSaved = System.currentTimeMillis();
        }
    }

    public String getDataStoreSize() {
        long bytes = this.getConfigXml().getFile().length();
        long kBytes = bytes / 1024L;
        if (kBytes == 0L) {
            return bytes + " bytes";
        }
        return kBytes + " kb";
    }

    public void doProcessForm(StaplerRequest request, StaplerResponse response) throws IOException, ServletException {
        if (request.getParameter("downloadStats") != null) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            PrintStream pos = new PrintStream(bos);
            ConvertXML.processXMLStats(ClusterStatisticsPlugin.getInstance().getConfigXml().getFile(), pos);
            ByteArrayInputStream is = new ByteArrayInputStream(bos.toByteArray());
            response.serveFile(request, (InputStream)is, this.lastSaved, 5000L, bos.size(), "cluster-stats.csv");
        } else if (request.getParameter("deleteStats") != null) {
            this.getStatsData().deleteAllStatistics();
            this.save();
            response.forwardToPreviousPage(request);
        }
    }

    public void cleanUp() {
        if (this.statsData.getAllWaitTimes().size() > 160000) {
            this.statsData.cleanUp(150000);
        }
    }
}

