/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import hudson.model.Action;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.graph.FlowGraphWalker;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graph.StepNode;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.TimeoutStepExecution;
import org.jenkinsci.plugins.workflow.test.steps.SemaphoreStep;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.BuildWatcher;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.TestExtension;
import org.kohsuke.stapler.DataBoundConstructor;

public class SynchronousNonBlockingStepExecutionTest {
    @Rule
    public JenkinsRule j = new JenkinsRule();
    @ClassRule
    public static BuildWatcher buildWatcher = new BuildWatcher();

    @Test
    public void basicNonBlockingStep() throws Exception {
        WorkflowJob p = (WorkflowJob)this.j.jenkins.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("node {\necho 'First message'\nsyncnonblocking 'wait'\necho 'Second message'\n}", true));
        WorkflowRun b = (WorkflowRun)p.scheduleBuild2(0, new Action[0]).getStartCondition().get();
        System.out.println("Waiting to syncnonblocking to start...");
        SynchronousNonBlockingStep.waitForStart("wait", b);
        Thread.sleep(250L);
        Assert.assertTrue((boolean)b.getExecutor().getAsynchronousExecution().blocksRestart());
        FlowGraphWalker walker = new FlowGraphWalker(b.getExecution());
        boolean found = false;
        for (FlowNode n : walker) {
            if (!(n instanceof StepNode) || !(((StepNode)n).getDescriptor() instanceof SynchronousNonBlockingStep.DescriptorImpl)) continue;
            found = true;
            break;
        }
        System.out.println("Checking flow node added...");
        Assert.assertTrue((String)"FlowNode has to be added just when the step starts running", (boolean)found);
        System.out.println("Checking build log message present...");
        this.j.waitForMessage("Test Sync Message", (Run)b);
        this.j.assertLogContains("First message", (Run)b);
        this.j.assertLogNotContains("Second message", (Run)b);
        SynchronousNonBlockingStep.notify("wait");
        System.out.println("Waiting until syncnonblocking (and the full flow) finishes");
        this.j.waitForCompletion((Run)b);
        System.out.println("Build finished. Continue.");
        this.j.assertLogContains("Second message", (Run)b);
        this.j.assertBuildStatusSuccess((Run)b);
    }

    @Test
    public void interruptedTest() throws Exception {
        WorkflowJob p = (WorkflowJob)this.j.jenkins.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("node {\necho 'First message'\ntry { syncnonblocking 'wait' } catch(InterruptedException e) { echo 'Interrupted!' }\necho 'Second message'\n}", true));
        WorkflowRun b = (WorkflowRun)p.scheduleBuild2(0, new Action[0]).getStartCondition().get();
        System.out.println("Waiting to syncnonblocking to start...");
        SynchronousNonBlockingStep.waitForStart("wait", b);
        b.getExecutor().interrupt();
        System.out.println("Looking for interruption received log message");
        this.j.waitForMessage("Interrupted!", (Run)b);
        this.j.waitForCompletion((Run)b);
        this.j.assertBuildStatus(Result.ABORTED, (Run)b);
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("timeout(time: 1, unit: 'SECONDS') {syncnonblocking 'wait2'}", true));
        this.j.assertLogContains(new TimeoutStepExecution.ExceededTimeout().getShortDescription(), this.j.assertBuildStatus(Result.ABORTED, (Future)p.scheduleBuild2(0, new Action[0])));
    }

    @Test
    public void parallelTest() throws Exception {
        WorkflowJob p = (WorkflowJob)this.j.jenkins.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("node {\necho 'First message'\nparallel( a: { syncnonblocking 'wait0'; echo 'a branch'; }, b: { semaphore 'wait1'; echo 'b branch'; } )\necho 'Second message'\n}", true));
        WorkflowRun b = (WorkflowRun)p.scheduleBuild2(0, new Action[0]).getStartCondition().get();
        SynchronousNonBlockingStep.waitForStart("wait0", b);
        SemaphoreStep.success((String)"wait1/1", null);
        this.j.waitForMessage("b branch", (Run)b);
        System.out.println("b branch finishes");
        this.j.assertLogNotContains("a branch", (Run)b);
        System.out.println("Continue on wait0");
        SynchronousNonBlockingStep.notify("wait0");
        this.j.waitForMessage("a branch", (Run)b);
        this.j.waitForCompletion((Run)b);
    }

    @Test
    public void errors() throws Exception {
        WorkflowJob p = (WorkflowJob)this.j.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("erroneous()", true));
        this.j.assertLogContains("ought to fail", this.j.assertBuildStatus(Result.FAILURE, (Future)p.scheduleBuild2(0, new Action[0])));
    }

    @Test
    public void contextClassLoader() throws Exception {
        WorkflowJob p = (WorkflowJob)this.j.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("org.jenkinsci.plugins.workflow.cps.CpsVmExecutorService.ORIGINAL_CONTEXT_CLASS_LOADER.set(null)\ncheckClassLoader()\n", false));
        this.j.assertBuildStatus(Result.SUCCESS, (Future)p.scheduleBuild2(0, new Action[0]));
    }

    public static final class SynchronousNonBlockingStep
    extends Step
    implements Serializable {
        private final String id;
        private static final long serialVersionUID = 1L;

        @DataBoundConstructor
        public SynchronousNonBlockingStep(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public StepExecution start(StepContext context) {
            return new StepExecutionImpl(this, context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void waitForStart(String id, Run<?, ?> b) throws InterruptedException {
            State s;
            State state = s = State.get();
            synchronized (state) {
                while (!s.started.contains(id)) {
                    if (b != null && !b.isBuilding()) {
                        throw new AssertionError();
                    }
                    s.wait(1000L);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void notify(String id) {
            State s;
            State state = s = State.get();
            synchronized (state) {
                if (s.started.remove(id)) {
                    s.notifyAll();
                }
            }
        }

        private static class StepExecutionImpl
        extends SynchronousNonBlockingStepExecution<Void> {
            private final transient SynchronousNonBlockingStep step;
            private static final long serialVersionUID = 1L;

            StepExecutionImpl(SynchronousNonBlockingStep step, StepContext context) {
                super(context);
                this.step = step;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Void run() throws Exception {
                State s;
                System.out.println("Starting syncnonblocking " + this.step.getId());
                ((TaskListener)this.getContext().get(TaskListener.class)).getLogger().println("Test Sync Message");
                State state = s = State.get();
                synchronized (state) {
                    s.started.add(this.step.getId());
                    s.notifyAll();
                }
                System.out.println("Sleeping inside the syncnonblocking thread (" + this.step.getId() + ")");
                state = s;
                synchronized (state) {
                    while (s.started.contains(this.step.getId())) {
                        s.wait(1000L);
                    }
                }
                System.out.println("Continue syncnonblocking " + this.step.getId());
                return null;
            }
        }

        public static final class State {
            private static final Map<File, State> states = new HashMap<File, State>();
            final Set<String> started = new HashSet<String>();

            static synchronized State get() {
                File home = Jenkins.get().getRootDir();
                State state = states.get(home);
                if (state == null) {
                    state = new State();
                    states.put(home, state);
                }
                return state;
            }

            private State() {
            }
        }

        @TestExtension
        public static final class DescriptorImpl
        extends StepDescriptor {
            public String getFunctionName() {
                return "syncnonblocking";
            }

            public String getDisplayName() {
                return "Sync non-blocking Test step";
            }

            public Set<? extends Class<?>> getRequiredContext() {
                return Collections.singleton(TaskListener.class);
            }
        }
    }

    public static final class CheckClassLoader
    extends Step {
        @DataBoundConstructor
        public CheckClassLoader() {
        }

        public StepExecution start(StepContext context) {
            return new Exec(context);
        }

        private static final class Exec
        extends SynchronousNonBlockingStepExecution<Void> {
            Exec(StepContext context) {
                super(context);
            }

            protected Void run() {
                if (Thread.currentThread().getContextClassLoader() == null) {
                    throw new AssertionError((Object)"Context class loader should not be null!");
                }
                return null;
            }
        }

        @TestExtension(value={"contextClassLoader"})
        public static final class DescriptorImpl
        extends StepDescriptor {
            public Set<? extends Class<?>> getRequiredContext() {
                return Collections.emptySet();
            }

            public String getFunctionName() {
                return "checkClassLoader";
            }
        }
    }

    public static final class Erroneous
    extends Step {
        @DataBoundConstructor
        public Erroneous() {
        }

        public StepExecution start(StepContext context) {
            return new Exec(context);
        }

        private static final class Exec
        extends SynchronousNonBlockingStepExecution<Void> {
            Exec(StepContext context) {
                super(context);
            }

            protected Void run() {
                throw new AssertionError((Object)"ought to fail");
            }
        }

        @TestExtension(value={"errors"})
        public static final class DescriptorImpl
        extends StepDescriptor {
            public Set<? extends Class<?>> getRequiredContext() {
                return Collections.emptySet();
            }

            public String getFunctionName() {
                return "erroneous";
            }
        }
    }
}

