/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.FreeStyleProject;
import hudson.model.Item;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.junit.Assert;
import org.jvnet.hudson.test.JenkinsRule;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

public final class StepConfigTester {
    private final JenkinsRule rule;

    public StepConfigTester(JenkinsRule rule) {
        this.rule = rule;
    }

    public <S extends Step> S configRoundTrip(S before) throws Exception {
        FreeStyleProject p = this.rule.createFreeStyleProject();
        p.getBuildersList().add((Object)new StepBuilder(before));
        p = (FreeStyleProject)this.rule.configRoundtrip((Item)p);
        StepBuilder b = (StepBuilder)p.getBuildersList().get(StepBuilder.class);
        Assert.assertNotNull((Object)((Object)b));
        Step after = b.s;
        Assert.assertNotNull((Object)after);
        Assert.assertEquals(before.getClass(), after.getClass());
        return (S)after;
    }

    @Restricted(value={NoExternalUse.class})
    public static final class StepBuilder
    extends Builder {
        public final Step s;

        @DataBoundConstructor
        public StepBuilder(Step s) {
            this.s = s;
        }

        @Extension
        public static final class DescriptorImpl
        extends BuildStepDescriptor<Builder> {
            public boolean isApplicable(Class<? extends AbstractProject> jobType) {
                return true;
            }

            public String getDisplayName() {
                return "Test step builder";
            }
        }
    }
}

