/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import hudson.Extension;
import hudson.model.Node;
import jakarta.inject.Inject;
import java.util.HashMap;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.mockito.Mockito;

public class AbstractStepImplTest {
    @Rule
    public JenkinsRule j = new JenkinsRule();
    @Inject
    BogusStep.DescriptorImpl d;

    @Before
    public void setUp() {
        this.j.getInstance().getInjector().injectMembers((Object)this);
    }

    @Test
    public void inject() throws Exception {
        HashMap<String, Object> r = new HashMap<String, Object>();
        r.put("a", 3);
        r.put("b", "bbb");
        r.put("c", null);
        r.put("d", "ddd");
        BogusStep step = (BogusStep)this.d.newInstance(r);
        Assert.assertEquals((long)step.a, (long)3L);
        Assert.assertEquals((Object)step.b, (Object)"bbb");
        Assert.assertNull((Object)step.c);
        Assert.assertEquals((Object)step.d, (Object)"ddd");
        StepContext c = (StepContext)Mockito.mock(StepContext.class);
        Mockito.when((Object)((Node)c.get(Node.class))).thenReturn((Object)this.j.getInstance());
        BogusStepExecution b = (BogusStepExecution)step.start(c);
        b.start();
    }

    public static class BogusStep
    extends AbstractStepImpl {
        int a;
        String b;
        @DataBoundSetter
        String c;
        Object d;

        @DataBoundConstructor
        public BogusStep(int a, String b) {
            this.a = a;
            this.b = b;
        }

        @DataBoundSetter
        void setD(Object value) {
            this.d = value;
        }

        @Extension
        public static class DescriptorImpl
        extends AbstractStepDescriptorImpl {
            public DescriptorImpl() {
                super(BogusStepExecution.class);
            }

            public String getFunctionName() {
                return "fff";
            }

            public String getDisplayName() {
                return "ggg";
            }
        }
    }

    public static class BogusStepExecution
    extends AbstractSynchronousStepExecution<Void> {
        @Inject
        Jenkins jenkins;
        @StepContextParameter
        Node n;

        protected Void run() {
            Assert.assertSame((Object)this.jenkins, (Object)Jenkins.getInstance());
            Assert.assertSame((Object)this.n, (Object)Jenkins.getInstance());
            return null;
        }
    }
}

