/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import java.io.OutputStream;
import java.util.Base64;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public final class WriteFileStep
extends Step {
    private final String file;
    private final String text;
    private String encoding;

    @DataBoundConstructor
    public WriteFileStep(String file, String text) {
        this.file = file;
        this.text = text;
    }

    public String getFile() {
        return this.file;
    }

    public String getText() {
        return this.text;
    }

    public String getEncoding() {
        return this.encoding;
    }

    @DataBoundSetter
    public void setEncoding(String encoding) {
        this.encoding = Util.fixEmptyAndTrim((String)encoding);
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    public static final class Execution
    extends SynchronousNonBlockingStepExecution<Void> {
        private final transient WriteFileStep step;
        private static final long serialVersionUID = 1L;

        Execution(WriteFileStep step, StepContext context) {
            super(context);
            this.step = step;
        }

        @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="https://github.com/spotbugs/spotbugs/issues/756")
        protected Void run() throws Exception {
            FilePath file = ((FilePath)this.getContext().get(FilePath.class)).child(this.step.file);
            if ("Base64".equals(this.step.encoding)) {
                try (OutputStream os = file.write();){
                    os.write(Base64.getDecoder().decode(this.step.text));
                }
            } else {
                file.write(this.step.text, this.step.encoding);
            }
            return null;
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "writeFile";
        }

        @NonNull
        public String getDisplayName() {
            return "Write file to workspace";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.singleton(FilePath.class);
        }

        public String argumentsToString(Map<String, Object> namedArgs) {
            Object file = namedArgs.get("file");
            return file instanceof String ? (String)file : null;
        }
    }
}

