/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.Extension;
import java.util.Collections;
import java.util.Set;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;

public final class ErrorStep
extends Step {
    private final String message;

    @DataBoundConstructor
    public ErrorStep(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this.message, context);
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "error";
        }

        @NonNull
        public String getDisplayName() {
            return "Error signal";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.emptySet();
        }
    }

    public static final class Execution
    extends SynchronousStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Only used when starting.")
        private final transient String message;

        Execution(String message, StepContext context) {
            super(context);
            this.message = message;
        }

        protected Void run() throws Exception {
            throw new AbortException(this.message);
        }
    }
}

