// CHECKSTYLE:OFF

package org.jenkinsci.plugins.workflow.steps;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code ArtifactArchiverStepExecution.NoFiles}: {@code No files
     * found to archive for pattern "{0}"; continuing.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No files found to archive for pattern "{0}"; continuing.}
     */
    public static String ArtifactArchiverStepExecution_NoFiles(Object arg0) {
        return holder.format("ArtifactArchiverStepExecution.NoFiles", arg0);
    }

    /**
     * Key {@code ArtifactArchiverStepExecution.NoFiles}: {@code No files
     * found to archive for pattern "{0}"; continuing.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No files found to archive for pattern "{0}"; continuing.}
     */
    public static Localizable _ArtifactArchiverStepExecution_NoFiles(Object arg0) {
        return new Localizable(holder, "ArtifactArchiverStepExecution.NoFiles", arg0);
    }

    /**
     * Key {@code ArtifactArchiverStepExecution.NoFilesWithExcludes}: {@code
     * No files found to archive for pattern "{0}", excluding "{1}";
     * continuing.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No files found to archive for pattern "{0}", excluding "{1}";
     *     continuing.}
     */
    public static String ArtifactArchiverStepExecution_NoFilesWithExcludes(Object arg0, Object arg1) {
        return holder.format("ArtifactArchiverStepExecution.NoFilesWithExcludes", arg0, arg1);
    }

    /**
     * Key {@code ArtifactArchiverStepExecution.NoFilesWithExcludes}: {@code
     * No files found to archive for pattern "{0}", excluding "{1}";
     * continuing.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No files found to archive for pattern "{0}", excluding "{1}";
     *     continuing.}
     */
    public static Localizable _ArtifactArchiverStepExecution_NoFilesWithExcludes(Object arg0, Object arg1) {
        return new Localizable(holder, "ArtifactArchiverStepExecution.NoFilesWithExcludes", arg0, arg1);
    }

    /**
     * Key {@code FileExistsStep.EmptyString}: {@code The fileExists step was
     * called with a null or empty string, so the current directory will be
     * checked instead.}.
     * 
     * @return
     *     {@code The fileExists step was called with a null or empty string, so
     *     the current directory will be checked instead.}
     */
    public static String FileExistsStep_EmptyString() {
        return holder.format("FileExistsStep.EmptyString");
    }

    /**
     * Key {@code FileExistsStep.EmptyString}: {@code The fileExists step was
     * called with a null or empty string, so the current directory will be
     * checked instead.}.
     * 
     * @return
     *     {@code The fileExists step was called with a null or empty string, so
     *     the current directory will be checked instead.}
     */
    public static Localizable _FileExistsStep_EmptyString() {
        return new Localizable(holder, "FileExistsStep.EmptyString");
    }

    /**
     * Key {@code ArtifactArchiverStepExecution.Deprecated}: {@code The
     * archive step is deprecated, please use archiveArtifacts instead.}.
     * 
     * @return
     *     {@code The archive step is deprecated, please use archiveArtifacts
     *     instead.}
     */
    public static String ArtifactArchiverStepExecution_Deprecated() {
        return holder.format("ArtifactArchiverStepExecution.Deprecated");
    }

    /**
     * Key {@code ArtifactArchiverStepExecution.Deprecated}: {@code The
     * archive step is deprecated, please use archiveArtifacts instead.}.
     * 
     * @return
     *     {@code The archive step is deprecated, please use archiveArtifacts
     *     instead.}
     */
    public static Localizable _ArtifactArchiverStepExecution_Deprecated() {
        return new Localizable(holder, "ArtifactArchiverStepExecution.Deprecated");
    }

}
