/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.steps.stash;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.flow.StashManager;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class StashStep
extends Step {
    @NonNull
    private final String name;
    @CheckForNull
    private String includes;
    @CheckForNull
    private String excludes;
    private boolean useDefaultExcludes = true;
    private boolean allowEmpty = false;

    @DataBoundConstructor
    public StashStep(@NonNull String name) {
        Jenkins.checkGoodName((String)name);
        this.name = name;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @CheckForNull
    public String getIncludes() {
        return this.includes;
    }

    @DataBoundSetter
    public void setIncludes(String includes) {
        this.includes = Util.fixEmpty((String)includes);
    }

    @CheckForNull
    public String getExcludes() {
        return this.excludes;
    }

    @DataBoundSetter
    public void setExcludes(String excludes) {
        this.excludes = Util.fixEmpty((String)excludes);
    }

    public boolean isUseDefaultExcludes() {
        return this.useDefaultExcludes;
    }

    @DataBoundSetter
    public void setUseDefaultExcludes(boolean useDefaultExcludes) {
        this.useDefaultExcludes = useDefaultExcludes;
    }

    public boolean isAllowEmpty() {
        return this.allowEmpty;
    }

    @DataBoundSetter
    public void setAllowEmpty(boolean allowEmpty) {
        this.allowEmpty = allowEmpty;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    public static class Execution
    extends SynchronousNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        private final transient StashStep step;

        Execution(StashStep step, StepContext context) {
            super(context);
            this.step = step;
        }

        protected Void run() throws Exception {
            StashManager.stash((Run)((Run)this.getContext().get(Run.class)), (String)this.step.name, (FilePath)((FilePath)this.getContext().get(FilePath.class)), (Launcher)((Launcher)this.getContext().get(Launcher.class)), (EnvVars)((EnvVars)this.getContext().get(EnvVars.class)), (TaskListener)((TaskListener)this.getContext().get(TaskListener.class)), (String)this.step.includes, (String)this.step.excludes, (boolean)this.step.useDefaultExcludes, (boolean)this.step.allowEmpty);
            return null;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "stash";
        }

        @NonNull
        public String getDisplayName() {
            return "Stash some files to be used later in the build";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            HashSet context = new HashSet();
            Collections.addAll(context, Run.class, FilePath.class, Launcher.class, EnvVars.class, TaskListener.class);
            return Collections.unmodifiableSet(context);
        }

        public String argumentsToString(Map<String, Object> namedArgs) {
            Object name = namedArgs.get("name");
            return name instanceof String ? (String)name : null;
        }
    }
}

