/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import com.google.common.util.concurrent.FutureCallback;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.console.ConsoleLogFilter;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildWrapperDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildWrapper;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.BodyInvoker;
import org.jenkinsci.plugins.workflow.steps.CoreStep;
import org.jenkinsci.plugins.workflow.steps.EnvironmentExpander;
import org.jenkinsci.plugins.workflow.steps.GeneralNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.MissingContextVariableException;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;

public class CoreWrapperStep
extends Step {
    private static final Logger LOGGER = Logger.getLogger(CoreWrapperStep.class.getName());
    private final SimpleBuildWrapper delegate;

    @DataBoundConstructor
    public CoreWrapperStep(SimpleBuildWrapper delegate) {
        this.delegate = delegate;
    }

    public SimpleBuildWrapper getDelegate() {
        return this.delegate;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution2(this.delegate, context);
    }

    private static final class Execution2
    extends GeneralNonBlockingStepExecution {
        private static final long serialVersionUID = 1L;
        private final transient SimpleBuildWrapper delegate;

        Execution2(SimpleBuildWrapper delegate, StepContext context) {
            super(context);
            this.delegate = delegate;
        }

        public boolean start() throws Exception {
            this.run(this::doStart);
            return false;
        }

        private void doStart() throws Exception {
            SimpleBuildWrapper.Disposer disposer;
            ConsoleLogFilter filter;
            SimpleBuildWrapper.Context c = this.delegate.createContext();
            StepContext context = this.getContext();
            Run run = (Run)context.get(Run.class);
            assert (run != null);
            TaskListener listener = (TaskListener)context.get(TaskListener.class);
            assert (listener != null);
            EnvVars env = (EnvVars)context.get(EnvVars.class);
            assert (env != null);
            FilePath workspace = (FilePath)context.get(FilePath.class);
            Launcher launcher = (Launcher)context.get(Launcher.class);
            if (this.delegate.requiresWorkspace()) {
                if (workspace == null) {
                    throw new MissingContextVariableException(FilePath.class);
                }
                if (launcher == null) {
                    throw new MissingContextVariableException(Launcher.class);
                }
            }
            if (workspace != null && launcher != null) {
                this.delegate.setUp(c, run, workspace, launcher, listener, env);
            } else {
                this.delegate.setUp(c, run, listener, env);
            }
            BodyInvoker bodyInvoker = context.newBodyInvoker();
            Map overrides = c.getEnv();
            if (!overrides.isEmpty()) {
                bodyInvoker.withContext((Object)EnvironmentExpander.merge((EnvironmentExpander)((EnvironmentExpander)context.get(EnvironmentExpander.class)), (EnvironmentExpander)new ExpanderImpl(overrides)));
            }
            if ((filter = this.delegate.createLoggerDecorator(run)) != null) {
                bodyInvoker.withContext((Object)BodyInvoker.mergeConsoleLogFilters((ConsoleLogFilter)((ConsoleLogFilter)context.get(ConsoleLogFilter.class)), (ConsoleLogFilter)filter));
            }
            bodyInvoker.withCallback((BodyExecutionCallback)((disposer = c.getDisposer()) != null ? new Callback2(disposer) : BodyExecutionCallback.wrap((FutureCallback)context))).start();
        }

        private final class Callback2
        extends GeneralNonBlockingStepExecution.TailCall {
            private static final long serialVersionUID = 1L;
            @NonNull
            private final SimpleBuildWrapper.Disposer disposer;

            Callback2(SimpleBuildWrapper.Disposer disposer) {
                super((GeneralNonBlockingStepExecution)Execution2.this);
                this.disposer = disposer;
            }

            protected void finished(StepContext context) throws Exception {
                new Callback(this.disposer).finished(context);
            }
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "wrap";
        }

        @NonNull
        public String getDisplayName() {
            return "General Build Wrapper";
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public boolean isMetaStep() {
            return true;
        }

        public Collection<BuildWrapperDescriptor> getApplicableDescriptors() {
            ArrayList<BuildWrapperDescriptor> r = new ArrayList<BuildWrapperDescriptor>();
            for (BuildWrapperDescriptor d : Jenkins.get().getExtensionList(BuildWrapperDescriptor.class)) {
                if (!SimpleBuildWrapper.class.isAssignableFrom(d.clazz)) continue;
                r.add(d);
            }
            return r;
        }

        public Set<? extends Class<?>> getRequiredContext() {
            HashSet context = new HashSet();
            Collections.addAll(context, Run.class, TaskListener.class, EnvVars.class);
            return Collections.unmodifiableSet(context);
        }

        public String argumentsToString(Map<String, Object> namedArgs) {
            Map<String, Object> delegateArguments = CoreStep.DescriptorImpl.delegateArguments(namedArgs.get("delegate"));
            return delegateArguments != null ? super.argumentsToString(delegateArguments) : null;
        }
    }

    private static final class Callback
    extends BodyExecutionCallback.TailCall {
        private static final long serialVersionUID = 1L;
        @NonNull
        private final SimpleBuildWrapper.Disposer disposer;

        Callback(@NonNull SimpleBuildWrapper.Disposer disposer) {
            this.disposer = disposer;
        }

        protected void finished(StepContext context) throws Exception {
            Launcher launcher;
            FilePath workspace;
            Run run = (Run)context.get(Run.class);
            assert (run != null);
            TaskListener listener = (TaskListener)context.get(TaskListener.class);
            assert (listener != null);
            if (this.disposer.requiresWorkspace()) {
                workspace = (FilePath)context.get(FilePath.class);
                if (workspace == null) {
                    throw new MissingContextVariableException(FilePath.class);
                }
                launcher = (Launcher)context.get(Launcher.class);
                if (launcher == null) {
                    throw new MissingContextVariableException(Launcher.class);
                }
            } else {
                try {
                    workspace = (FilePath)context.get(FilePath.class);
                    launcher = (Launcher)context.get(Launcher.class);
                }
                catch (IOException | InterruptedException x) {
                    LOGGER.log(Level.FINE, null, x);
                    workspace = null;
                    launcher = null;
                }
            }
            if (workspace != null && launcher != null) {
                this.disposer.tearDown(run, workspace, launcher, listener);
            } else {
                this.disposer.tearDown(run, listener);
            }
        }
    }

    private static final class ExpanderImpl
    extends EnvironmentExpander {
        private static final long serialVersionUID = 1L;
        private final Map<String, String> overrides;

        ExpanderImpl(Map<String, String> overrides) {
            this.overrides = new HashMap<String, String>(overrides);
        }

        public void expand(EnvVars env) throws IOException, InterruptedException {
            env.overrideExpandingAll(this.overrides);
        }
    }

    @Deprecated
    public static final class Execution
    extends AbstractStepExecutionImpl {
        private static final long serialVersionUID = 1L;

        public boolean start() throws Exception {
            throw new AssertionError();
        }
    }
}

