/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.scm_sync_configuration.xstream;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import hudson.plugins.scm_sync_configuration.ScmSyncConfigurationPlugin;
import hudson.plugins.scm_sync_configuration.xstream.migration.ScmSyncConfigurationDataMigrator;
import hudson.plugins.scm_sync_configuration.xstream.migration.ScmSyncConfigurationPOJO;
import hudson.plugins.scm_sync_configuration.xstream.migration.v0.InitialMigrator;
import hudson.plugins.scm_sync_configuration.xstream.migration.v1.V0ToV1Migrator;
import java.util.logging.Logger;

public class ScmSyncConfigurationXStreamConverter
implements Converter {
    private static final Logger LOGGER = Logger.getLogger(ScmSyncConfigurationXStreamConverter.class.getName());
    protected static final String VERSION_ATTRIBUTE = "version";
    private static final ScmSyncConfigurationDataMigrator[] MIGRATORS = new ScmSyncConfigurationDataMigrator[]{new InitialMigrator(), new V0ToV1Migrator()};

    public boolean canConvert(Class type) {
        return ScmSyncConfigurationPlugin.class.isAssignableFrom(type);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        ScmSyncConfigurationPlugin plugin = (ScmSyncConfigurationPlugin)((Object)source);
        writer.addAttribute(VERSION_ATTRIBUTE, String.valueOf(ScmSyncConfigurationXStreamConverter.getCurrentScmSyncConfigurationVersionNumber()));
        if (plugin.getSCM() != null) {
            writer.startNode("scm");
            writer.addAttribute("class", plugin.getSCM().getId());
            writer.endNode();
        }
        if (plugin.getScmRepositoryUrl() != null) {
            writer.startNode("scmRepositoryUrl");
            writer.setValue(plugin.getScmRepositoryUrl());
            writer.endNode();
        }
        writer.startNode("noUserCommitMessage");
        writer.setValue(Boolean.toString(plugin.isNoUserCommitMessage()));
        writer.endNode();
        writer.startNode("displayStatus");
        writer.setValue(Boolean.toString(plugin.isDisplayStatus()));
        writer.endNode();
        if (plugin.getCommitMessagePattern() != null) {
            writer.startNode("commitMessagePattern");
            writer.setValue(plugin.getCommitMessagePattern());
            writer.endNode();
        }
        if (plugin.getManualSynchronizationIncludes() != null) {
            writer.startNode("manualSynchronizationIncludes");
            for (String include : plugin.getManualSynchronizationIncludes()) {
                writer.startNode("include");
                writer.setValue(include);
                writer.endNode();
            }
            writer.endNode();
        }
    }

    private static int getCurrentScmSyncConfigurationVersionNumber() {
        return MIGRATORS.length - 1;
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        ScmSyncConfigurationPlugin plugin = context.currentObject() == null || !(context.currentObject() instanceof ScmSyncConfigurationPlugin) ? new ScmSyncConfigurationPlugin() : (ScmSyncConfigurationPlugin)((Object)context.currentObject());
        String version = reader.getAttribute(VERSION_ATTRIBUTE);
        int versionNumber = 0;
        if (version != null) {
            versionNumber = Integer.parseInt(version);
        }
        if (versionNumber != ScmSyncConfigurationXStreamConverter.getCurrentScmSyncConfigurationVersionNumber()) {
            LOGGER.info("Your version of persisted ScmSyncConfigurationPlugin data is not up-to-date (v" + versionNumber + " < v" + ScmSyncConfigurationXStreamConverter.getCurrentScmSyncConfigurationVersionNumber() + ") : data will be migrated !");
        }
        Object pojo = MIGRATORS[versionNumber].readScmSyncConfigurationPOJO(reader, context);
        for (int i = versionNumber + 1; i < ScmSyncConfigurationXStreamConverter.getCurrentScmSyncConfigurationVersionNumber() + 1; ++i) {
            pojo = MIGRATORS[i].migrate(pojo);
        }
        plugin.loadData((ScmSyncConfigurationPOJO)pojo);
        return plugin;
    }
}

