/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.scm_sync_configuration.transactions;

import hudson.plugins.scm_sync_configuration.ScmSyncConfigurationPlugin;
import hudson.plugins.scm_sync_configuration.model.ChangeSet;
import hudson.plugins.scm_sync_configuration.model.WeightedMessage;

public abstract class ScmTransaction {
    private ChangeSet changeset = new ChangeSet();
    private boolean synchronousCommit;

    protected ScmTransaction() {
        this(false);
    }

    protected ScmTransaction(boolean synchronousCommit) {
        this.synchronousCommit = synchronousCommit;
    }

    public void defineCommitMessage(WeightedMessage weightedMessage) {
        this.changeset.defineMessage(weightedMessage);
    }

    public void commit() {
        ScmSyncConfigurationPlugin.getInstance().commitChangeset(this.changeset);
        if (this.synchronousCommit) {
            try {
                ScmSyncConfigurationPlugin.getInstance().getLatestCommitFuture().get();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void registerPath(String path) {
        this.changeset.registerPath(path);
    }

    public void registerPathForDeletion(String path) {
        this.changeset.registerPathForDeletion(path);
    }

    public void registerRenamedPath(String oldPath, String newPath) {
        this.changeset.registerRenamedPath(oldPath, newPath);
    }
}

