/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.scm_sync_configuration.strategies.model;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import hudson.model.Saveable;
import hudson.plugins.scm_sync_configuration.JenkinsFilesHelper;
import hudson.plugins.scm_sync_configuration.strategies.model.ConfigurationEntityMatcher;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.tools.ant.DirectoryScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternsEntityMatcher
implements ConfigurationEntityMatcher {
    private static final Function<String, String> FILE_SEPARATOR_TRANSFORMER = new Function<String, String>(){

        public String apply(@Nullable String s) {
            return s.replaceAll("/", File.separator);
        }
    };
    private String[] patterns;

    public PatternsEntityMatcher(String[] patterns) {
        this.patterns = Collections2.transform(Arrays.asList(patterns), FILE_SEPARATOR_TRANSFORMER).toArray(new String[0]);
    }

    @Override
    public boolean matches(Saveable saveable, File file) {
        if (file == null) {
            return false;
        }
        String filePathRelativeToHudsonRoot = JenkinsFilesHelper.buildPathRelativeToHudsonRoot(file);
        for (String pattern : this.patterns) {
            if (!DirectoryScanner.match((String)pattern, (String)filePathRelativeToHudsonRoot)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<String> getIncludes() {
        return Arrays.asList(this.patterns);
    }

    @Override
    public String[] matchingFilesFrom(File rootDirectory) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setIncludes(this.patterns);
        scanner.setBasedir(rootDirectory);
        scanner.scan();
        return scanner.getIncludedFiles();
    }
}

