/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.scm_sync_configuration.strategies.impl;

import hudson.XmlFile;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Saveable;
import hudson.plugins.scm_sync_configuration.model.MessageWeight;
import hudson.plugins.scm_sync_configuration.model.WeightedMessage;
import hudson.plugins.scm_sync_configuration.strategies.AbstractScmSyncStrategy;
import hudson.plugins.scm_sync_configuration.strategies.ScmSyncStrategy;
import hudson.plugins.scm_sync_configuration.strategies.model.ClassAndFileConfigurationEntityMatcher;
import hudson.plugins.scm_sync_configuration.strategies.model.ConfigurationEntityMatcher;
import hudson.plugins.scm_sync_configuration.strategies.model.PageMatcher;
import java.util.ArrayList;
import java.util.List;

public class JobConfigScmSyncStrategy
extends AbstractScmSyncStrategy {
    private static final List<PageMatcher> PAGE_MATCHERS = new ArrayList<PageMatcher>(){
        {
            this.add(new PageMatcher("^(.*view/[^/]+/)?job/[^/]+/configure$", "form[name='config']"));
        }
    };
    private static final String[] PATTERNS = new String[]{"jobs/*/config.xml"};
    private static final ConfigurationEntityMatcher CONFIG_ENTITY_MANAGER = new ClassAndFileConfigurationEntityMatcher(Job.class, PATTERNS);

    public JobConfigScmSyncStrategy() {
        super(CONFIG_ENTITY_MANAGER, PAGE_MATCHERS);
    }

    public ScmSyncStrategy.CommitMessageFactory getCommitMessageFactory() {
        return new ScmSyncStrategy.CommitMessageFactory(){

            public WeightedMessage getMessageWhenSaveableUpdated(Saveable s, XmlFile file) {
                return new WeightedMessage("Job [" + ((Job)s).getName() + "] configuration updated", MessageWeight.IMPORTANT);
            }

            public WeightedMessage getMessageWhenItemRenamed(Item item, String oldPath, String newPath) {
                return new WeightedMessage("Job [" + item.getName() + "] hierarchy renamed from [" + oldPath + "] to [" + newPath + "]", MessageWeight.MORE_IMPORTANT);
            }

            public WeightedMessage getMessageWhenItemDeleted(Item item) {
                return new WeightedMessage("Job [" + item.getName() + "] hierarchy deleted", MessageWeight.MORE_IMPORTANT);
            }
        };
    }
}

