/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.scm_sync_configuration.strategies;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import hudson.XmlFile;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.Saveable;
import hudson.plugins.scm_sync_configuration.model.MessageWeight;
import hudson.plugins.scm_sync_configuration.model.WeightedMessage;
import hudson.plugins.scm_sync_configuration.strategies.ScmSyncStrategy;
import hudson.plugins.scm_sync_configuration.strategies.model.ConfigurationEntityMatcher;
import hudson.plugins.scm_sync_configuration.strategies.model.PageMatcher;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractScmSyncStrategy
implements ScmSyncStrategy {
    private static final Function<String, File> PATH_TO_FILE_IN_HUDSON = new Function<String, File>(){

        public File apply(@Nullable String path) {
            return new File(Hudson.getInstance().getRootDir() + File.separator + path);
        }
    };
    private ConfigurationEntityMatcher configEntityMatcher;
    private List<PageMatcher> pageMatchers;

    protected AbstractScmSyncStrategy(ConfigurationEntityMatcher _configEntityMatcher, List<PageMatcher> _pageMatchers) {
        this.configEntityMatcher = _configEntityMatcher;
        this.pageMatchers = _pageMatchers;
    }

    protected ConfigurationEntityMatcher createConfigEntityMatcher() {
        return this.configEntityMatcher;
    }

    @Override
    public boolean isSaveableApplicable(Saveable saveable, File file) {
        return this.createConfigEntityMatcher().matches(saveable, file);
    }

    public PageMatcher getPageMatcherMatching(String url) {
        String rootUrl = Hudson.getInstance().getRootUrlFromRequest();
        String cleanedUrl = null;
        cleanedUrl = url.startsWith(rootUrl) ? url.substring(rootUrl.length()) : url;
        for (PageMatcher pm : this.pageMatchers) {
            if (!pm.getUrlRegex().matcher(cleanedUrl).matches()) continue;
            return pm;
        }
        return null;
    }

    @Override
    public List<File> createInitializationSynchronizedFileset() {
        File hudsonRoot = Hudson.getInstance().getRootDir();
        String[] matchingFilePaths = this.createConfigEntityMatcher().matchingFilesFrom(hudsonRoot);
        return new ArrayList<File>(Collections2.transform(Arrays.asList(matchingFilePaths), PATH_TO_FILE_IN_HUDSON));
    }

    @Override
    public boolean isCurrentUrlApplicable(String url) {
        return this.getPageMatcherMatching(url) != null;
    }

    @Override
    public List<String> getSyncIncludes() {
        return this.createConfigEntityMatcher().getIncludes();
    }

    @Override
    public ScmSyncStrategy.CommitMessageFactory getCommitMessageFactory() {
        return new DefaultCommitMessageFactory();
    }

    protected static class DefaultCommitMessageFactory
    implements ScmSyncStrategy.CommitMessageFactory {
        protected DefaultCommitMessageFactory() {
        }

        public WeightedMessage getMessageWhenSaveableUpdated(Saveable s, XmlFile file) {
            return new WeightedMessage("Modification on configuration(s)", MessageWeight.MINIMAL);
        }

        public WeightedMessage getMessageWhenItemRenamed(Item item, String oldPath, String newPath) {
            return new WeightedMessage("Item renamed", MessageWeight.MINIMAL);
        }

        public WeightedMessage getMessageWhenItemDeleted(Item item) {
            return new WeightedMessage("File hierarchy deleted", MessageWeight.MINIMAL);
        }
    }
}

