/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.scm_sync_configuration.model;

import hudson.plugins.scm_sync_configuration.JenkinsFilesHelper;
import hudson.plugins.scm_sync_configuration.ScmSyncConfigurationBusiness;
import java.io.File;

public class Path {
    private String path;
    private boolean isDirectory;

    public Path(String path) {
        this(JenkinsFilesHelper.buildFileFromPathRelativeToHudsonRoot(path));
    }

    public Path(File hudsonFile) {
        this(JenkinsFilesHelper.buildPathRelativeToHudsonRoot(hudsonFile), hudsonFile.isDirectory());
    }

    public Path(String path, boolean isDirectory) {
        this.path = path;
        this.isDirectory = isDirectory;
    }

    public String getPath() {
        return this.path;
    }

    public File getHudsonFile() {
        return JenkinsFilesHelper.buildFileFromPathRelativeToHudsonRoot(this.path);
    }

    public File getScmFile() {
        return new File(ScmSyncConfigurationBusiness.getCheckoutScmDirectoryAbsolutePath() + File.separator + this.getPath());
    }

    public String getFirstNonExistingParentScmPath() {
        File scmFile = this.getScmFile();
        File latestNonExistingScmFile = null;
        File currentFile = scmFile;
        while (!currentFile.exists()) {
            latestNonExistingScmFile = currentFile;
            currentFile = currentFile.getParentFile();
        }
        return latestNonExistingScmFile.getAbsolutePath().substring(ScmSyncConfigurationBusiness.getCheckoutScmDirectoryAbsolutePath().length() + 1);
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public boolean contains(Path p) {
        return this.isDirectory() && p.getPath().startsWith(this.getPath());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Path)) {
            return false;
        }
        Path path1 = (Path)o;
        if (this.isDirectory != path1.isDirectory) {
            return false;
        }
        return !(this.path != null ? !this.path.equals(path1.path) : path1.path != null);
    }

    public int hashCode() {
        int result = this.path != null ? this.path.hashCode() : 0;
        result = 31 * result + (this.isDirectory ? 1 : 0);
        return result;
    }

    public String toString() {
        return this.getPath() + (this.isDirectory() ? "/" : "");
    }
}

