/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.scm_sync_configuration.model;

import hudson.model.User;
import hudson.plugins.scm_sync_configuration.model.ChangeSet;
import hudson.plugins.scm_sync_configuration.model.ScmContext;

public class Commit {
    String message;
    ChangeSet changeset;
    ScmContext scmContext;
    User author;

    public Commit(ChangeSet changeset, User author, String userMessage, ScmContext scmContext) {
        this.message = Commit.createCommitMessage(scmContext, changeset.getMessage(), author, userMessage);
        this.changeset = changeset;
        this.scmContext = scmContext;
        this.author = author;
    }

    public String getMessage() {
        return this.message;
    }

    public ChangeSet getChangeset() {
        return this.changeset;
    }

    public ScmContext getScmContext() {
        return this.scmContext;
    }

    private static String createCommitMessage(ScmContext context, String messagePrefix, User user, String userComment) {
        StringBuilder commitMessage = new StringBuilder();
        commitMessage.append(messagePrefix);
        if (user != null) {
            commitMessage.append(" by ").append(user.getId());
        }
        if (userComment != null && !"".equals(userComment)) {
            commitMessage.append(" with following comment : ").append(userComment);
        }
        String message = commitMessage.toString();
        if (context.getCommitMessagePattern() == null || "".equals(context.getCommitMessagePattern())) {
            return message;
        }
        return context.getCommitMessagePattern().replaceAll("\\[message\\]", message.replaceAll("\\$", "\\\\\\$"));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Commit %s : %n", super.toString()));
        sb.append(String.format("  Author : %s%n", String.valueOf(this.author)));
        sb.append(String.format("  Comment : %s%n", this.message));
        sb.append(String.format("  Changeset : %n%s%n", this.changeset.toString()));
        return sb.toString();
    }
}

