/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.scm_sync_configuration.model;

import com.google.common.io.Files;
import hudson.plugins.scm_sync_configuration.JenkinsFilesHelper;
import hudson.plugins.scm_sync_configuration.exceptions.LoggableException;
import hudson.plugins.scm_sync_configuration.model.Path;
import hudson.plugins.scm_sync_configuration.model.WeightedMessage;
import hudson.plugins.scm_sync_configuration.utils.Checksums;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeSet {
    private static final Logger LOGGER = Logger.getLogger(ChangeSet.class.getName());
    WeightedMessage message = null;
    Map<Path, byte[]> pathContents = new HashMap<Path, byte[]>();
    List<Path> pathsToDelete = new ArrayList<Path>();

    public void registerPath(String path) {
        boolean contentAlreadyRegistered = false;
        File hudsonFile = JenkinsFilesHelper.buildFileFromPathRelativeToHudsonRoot(path);
        Path pathToRegister = new Path(hudsonFile);
        if (pathToRegister.isDirectory()) {
            this.pathContents.put(pathToRegister, new byte[0]);
        } else {
            if (this.pathContents.containsKey(pathToRegister)) {
                try {
                    contentAlreadyRegistered = Checksums.fileAndByteArrayContentAreEqual(pathToRegister.getHudsonFile(), this.pathContents.get(pathToRegister));
                }
                catch (IOException e) {
                    throw new LoggableException("Changeset path <" + path + "> registration failed", Checksums.class, "fileAndByteArrayContentAreEqual", e);
                }
            }
            if (!contentAlreadyRegistered) {
                try {
                    this.pathContents.put(pathToRegister, Files.toByteArray((File)pathToRegister.getHudsonFile()));
                }
                catch (IOException e) {
                    throw new LoggableException("Changeset path <" + path + "> registration failed", Files.class, "toByteArray", e);
                }
            }
        }
    }

    public void registerRenamedPath(String oldPath, String newPath) {
        this.registerPathForDeletion(oldPath);
        this.registerPath(newPath);
    }

    public void registerPathForDeletion(String path) {
        boolean isDirectory = new Path(path).getScmFile().isDirectory();
        this.pathsToDelete.add(new Path(path, isDirectory));
    }

    public boolean isEmpty() {
        return this.pathContents.isEmpty() && this.pathsToDelete.isEmpty();
    }

    public Map<Path, byte[]> getPathContents() {
        HashMap<Path, byte[]> filteredPathContents = new HashMap<Path, byte[]>(this.pathContents);
        ArrayList<Path> filteredPaths = new ArrayList<Path>();
        for (Path pathToAdd : filteredPathContents.keySet()) {
            for (Path pathToDelete : this.pathsToDelete) {
                if (!pathToDelete.contains(pathToAdd)) continue;
                filteredPaths.add(pathToAdd);
            }
        }
        for (Path path : filteredPaths) {
            filteredPathContents.remove(path);
        }
        return filteredPathContents;
    }

    public List<Path> getPathsToDelete() {
        return Collections.unmodifiableList(this.pathsToDelete);
    }

    public void defineMessage(WeightedMessage weightedMessage) {
        if (this.message == null || weightedMessage.getWeight().weighterThan(this.message.getWeight())) {
            this.message = weightedMessage;
        }
    }

    public String getMessage() {
        return this.message.getMessage();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Path path : this.getPathContents().keySet()) {
            sb.append(String.format("    A %s%n", path.toString()));
        }
        for (Path path : this.getPathsToDelete()) {
            sb.append(String.format("    D %s%n", path.toString()));
        }
        return sb.toString();
    }
}

