/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.scm_sync_configuration;

import hudson.model.Hudson;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.logging.Logger;
import org.codehaus.plexus.util.FileUtils;

public class ScmSyncConfigurationStatusManager {
    private static final Logger LOGGER = Logger.getLogger(ScmSyncConfigurationStatusManager.class.getName());
    public static final String LOG_SUCCESS_FILENAME = "scm-sync-configuration.success.log";
    public static final String LOG_FAIL_FILENAME = "scm-sync-configuration.fail.log";
    private File fail = new File(Hudson.getInstance().getRootDir().getAbsolutePath() + File.separator + "scm-sync-configuration.fail.log");
    private File success = new File(Hudson.getInstance().getRootDir().getAbsolutePath() + File.separator + "scm-sync-configuration.success.log");

    public String getLastFail() {
        return ScmSyncConfigurationStatusManager.readFile(this.fail);
    }

    public String getLastSuccess() {
        return ScmSyncConfigurationStatusManager.readFile(this.success);
    }

    public void signalSuccess() {
        ScmSyncConfigurationStatusManager.writeFile(this.success, new Date().toString());
    }

    public void signalFailed(String description) {
        ScmSyncConfigurationStatusManager.appendFile(this.fail, new Date().toString() + " : " + description + "<br/>");
    }

    private static String readFile(File f) {
        try {
            if (f.exists()) {
                return FileUtils.fileRead((File)f);
            }
        }
        catch (IOException e) {
            LOGGER.severe("Unable to read file " + f.getAbsolutePath() + " : " + e.getMessage());
        }
        return null;
    }

    private static void writeFile(File f, String data) {
        try {
            FileUtils.fileWrite((String)f.getAbsolutePath(), (String)data);
        }
        catch (IOException e) {
            LOGGER.severe("Unable to write file " + f.getAbsolutePath() + " : " + e.getMessage());
        }
    }

    private static void appendFile(File f, String data) {
        try {
            FileUtils.fileAppend((String)f.getAbsolutePath(), (String)data);
        }
        catch (IOException e) {
            LOGGER.severe("Unable to write file " + f.getAbsolutePath() + " : " + e.getMessage());
        }
    }
}

