/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.scm_sync_configuration;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.thoughtworks.xstream.converters.Converter;
import hudson.Plugin;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Saveable;
import hudson.model.User;
import hudson.plugins.scm_sync_configuration.SCMManagerFactory;
import hudson.plugins.scm_sync_configuration.ScmSyncConfigurationBusiness;
import hudson.plugins.scm_sync_configuration.ScmSyncConfigurationDataProvider;
import hudson.plugins.scm_sync_configuration.ScmSyncConfigurationStatusManager;
import hudson.plugins.scm_sync_configuration.extensions.ScmSyncConfigurationFilter;
import hudson.plugins.scm_sync_configuration.model.ChangeSet;
import hudson.plugins.scm_sync_configuration.model.ScmContext;
import hudson.plugins.scm_sync_configuration.scms.SCM;
import hudson.plugins.scm_sync_configuration.scms.ScmSyncNoSCM;
import hudson.plugins.scm_sync_configuration.strategies.ScmSyncStrategy;
import hudson.plugins.scm_sync_configuration.strategies.impl.BasicPluginsConfigScmSyncStrategy;
import hudson.plugins.scm_sync_configuration.strategies.impl.JenkinsConfigScmSyncStrategy;
import hudson.plugins.scm_sync_configuration.strategies.impl.JobConfigScmSyncStrategy;
import hudson.plugins.scm_sync_configuration.strategies.impl.ManualIncludesScmSyncStrategy;
import hudson.plugins.scm_sync_configuration.transactions.AtomicTransaction;
import hudson.plugins.scm_sync_configuration.transactions.ScmTransaction;
import hudson.plugins.scm_sync_configuration.transactions.ThreadedTransaction;
import hudson.plugins.scm_sync_configuration.xstream.ScmSyncConfigurationXStreamConverter;
import hudson.plugins.scm_sync_configuration.xstream.migration.ScmSyncConfigurationPOJO;
import hudson.util.PluginServletFilter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.servlet.Filter;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import net.sf.json.JSONObject;
import org.acegisecurity.AccessDeniedException;
import org.apache.maven.scm.ScmException;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScmSyncConfigurationPlugin
extends Plugin {
    public static final transient ScmSyncStrategy[] AVAILABLE_STRATEGIES = new ScmSyncStrategy[]{new JenkinsConfigScmSyncStrategy(), new BasicPluginsConfigScmSyncStrategy(), new JobConfigScmSyncStrategy(), new ManualIncludesScmSyncStrategy()};
    public static final transient List<ScmSyncStrategy> DEFAULT_STRATEGIES = new ArrayList<ScmSyncStrategy>(){
        {
            this.addAll(Collections2.filter(Arrays.asList(AVAILABLE_STRATEGIES), (Predicate)new Predicate<ScmSyncStrategy>(){

                public boolean apply(@Nullable ScmSyncStrategy scmSyncStrategy) {
                    return !(scmSyncStrategy instanceof ManualIncludesScmSyncStrategy);
                }
            }));
        }
    };
    private static final Logger LOGGER = Logger.getLogger(ScmSyncConfigurationPlugin.class.getName());
    private transient ScmSyncConfigurationBusiness business;
    private transient boolean synchronousTransactions = false;
    private transient ThreadLocal<ScmTransaction> transaction = new ThreadLocal();
    private transient Future<Void> latestCommitFuture;
    private String scmRepositoryUrl;
    private SCM scm;
    private boolean noUserCommitMessage;
    private boolean displayStatus = true;
    private String commitMessagePattern = "[message]";
    private List<File> filesModifiedByLastReload;
    private List<String> manualSynchronizationIncludes;

    public ScmSyncConfigurationPlugin() {
        this(false);
    }

    public ScmSyncConfigurationPlugin(boolean synchronousTransactions) {
        this.synchronousTransactions = synchronousTransactions;
        this.setBusiness(new ScmSyncConfigurationBusiness());
        try {
            PluginServletFilter.addFilter((Filter)new ScmSyncConfigurationFilter());
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> getManualSynchronizationIncludes() {
        return this.manualSynchronizationIncludes;
    }

    public void start() throws Exception {
        super.start();
        Hudson.XSTREAM.registerConverter((Converter)new ScmSyncConfigurationXStreamConverter());
        this.load();
        if (this.scm == null) {
            this.scm = SCM.valueOf(ScmSyncNoSCM.class);
            this.scmRepositoryUrl = null;
        }
        SCMManagerFactory.getInstance().start();
    }

    public void loadData(ScmSyncConfigurationPOJO pojo) {
        this.scmRepositoryUrl = pojo.getScmRepositoryUrl();
        this.scm = pojo.getScm();
        this.noUserCommitMessage = pojo.isNoUserCommitMessage();
        this.displayStatus = pojo.isDisplayStatus();
        this.commitMessagePattern = pojo.getCommitMessagePattern();
        this.manualSynchronizationIncludes = pojo.getManualSynchronizationIncludes();
    }

    public void init() {
        try {
            this.business.init(this.createScmContext());
        }
        catch (Exception e) {
            throw new RuntimeException("Error during ScmSyncConfiguration initialisation !", e);
        }
    }

    public void stop() throws Exception {
        SCMManagerFactory.getInstance().stop();
        super.stop();
    }

    public void configure(StaplerRequest req, JSONObject formData) throws IOException, ServletException, Descriptor.FormException {
        super.configure(req, formData);
        boolean repoInitializationRequired = false;
        boolean configsResynchronizationRequired = false;
        boolean repoCleaningRequired = false;
        this.noUserCommitMessage = formData.getBoolean("noUserCommitMessage");
        this.displayStatus = formData.getBoolean("displayStatus");
        this.commitMessagePattern = req.getParameter("commitMessagePattern");
        String oldScmRepositoryUrl = this.scmRepositoryUrl;
        String scmType = req.getParameter("scm");
        if (scmType != null) {
            String newScmRepositoryUrl;
            this.scm = SCM.valueOf(scmType);
            this.scmRepositoryUrl = newScmRepositoryUrl = this.scm.createScmUrlFromRequest(req);
            configsResynchronizationRequired = repoInitializationRequired = newScmRepositoryUrl != null && !newScmRepositoryUrl.equals(oldScmRepositoryUrl);
            boolean bl = repoCleaningRequired = newScmRepositoryUrl == null && oldScmRepositoryUrl != null;
        }
        if (req.getParameterValues("manualSynchronizationIncludes") != null) {
            ArrayList<String> submittedManualIncludes = new ArrayList<String>(Arrays.asList(req.getParameterValues("manualSynchronizationIncludes")));
            ArrayList<String> newManualIncludes = new ArrayList<String>(submittedManualIncludes);
            if (this.manualSynchronizationIncludes != null) {
                newManualIncludes.removeAll(this.manualSynchronizationIncludes);
            }
            this.manualSynchronizationIncludes = submittedManualIncludes;
            configsResynchronizationRequired = !newManualIncludes.isEmpty();
        } else {
            this.manualSynchronizationIncludes = new ArrayList<String>();
        }
        if (repoInitializationRequired) {
            this.business.initializeRepository(this.createScmContext(), true);
        }
        if (configsResynchronizationRequired) {
            this.business.synchronizeAllConfigs(AVAILABLE_STRATEGIES);
        }
        if (repoCleaningRequired) {
            this.business.cleanChekoutScmDirectory();
        }
        this.save();
    }

    public void doReloadAllFilesFromScm(StaplerRequest req, StaplerResponse res) throws ServletException, IOException {
        try {
            this.filesModifiedByLastReload = this.business.reloadAllFilesFromScm();
            req.getView((Object)this, "/hudson/plugins/scm_sync_configuration/reload.jelly").forward((ServletRequest)req, (ServletResponse)res);
        }
        catch (ScmException e) {
            throw new ServletException("Unable to reload SCM " + this.scm.getTitle() + ":" + this.getScmUrl(), (Throwable)e);
        }
    }

    public void doSubmitComment(StaplerRequest req, StaplerResponse res) throws ServletException, IOException {
        ScmSyncConfigurationDataProvider.provideComment(req.getParameter("comment"));
        if (Boolean.valueOf(req.getParameter("dontBotherMe")).booleanValue()) {
            ScmSyncConfigurationDataProvider.provideBotherTimeout(req.getParameter("botherType"), Integer.valueOf(req.getParameter("botherTime")), req.getParameter("currentURL"));
        }
    }

    public void doHelpForRepositoryUrl(StaplerRequest req, StaplerResponse res) throws ServletException, IOException {
        req.getView((Object)this, SCM.valueOf(req.getParameter("scm")).getRepositoryUrlHelpPath()).forward((ServletRequest)req, (ServletResponse)res);
    }

    public void doManualIncludesHelp(StaplerRequest req, StaplerResponse res) throws ServletException, IOException {
        req.getView((Object)this, "/hudson/plugins/scm_sync_configuration/ScmSyncConfigurationPlugin/help/manualSynchronizationIncludes.jelly").forward((ServletRequest)req, (ServletResponse)res);
    }

    public void doSynchronizeFile(@QueryParameter String path) {
        this.getTransaction().registerPath(path);
    }

    public List<String> getDefaultIncludes() {
        ArrayList<String> includes = new ArrayList<String>();
        for (ScmSyncStrategy strategy : DEFAULT_STRATEGIES) {
            includes.addAll(strategy.getSyncIncludes());
        }
        return includes;
    }

    private User getCurrentUser() {
        User user = null;
        try {
            user = Hudson.getInstance().getMe();
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
        return user;
    }

    public static ScmSyncConfigurationPlugin getInstance() {
        return (ScmSyncConfigurationPlugin)Hudson.getInstance().getPlugin(ScmSyncConfigurationPlugin.class);
    }

    public ScmSyncStrategy getStrategyForSaveable(Saveable s, File f) {
        for (ScmSyncStrategy strat : AVAILABLE_STRATEGIES) {
            if (!strat.isSaveableApplicable(s, f)) continue;
            return strat;
        }
        return null;
    }

    public ScmContext createScmContext() {
        return new ScmContext(this.scm, this.scmRepositoryUrl, this.commitMessagePattern);
    }

    public boolean shouldDecorationOccursOnURL(String url) {
        ScmSyncConfigurationDataProvider.retrieveComment(true);
        return !this.noUserCommitMessage && ScmSyncConfigurationDataProvider.retrieveBotherTimeoutMatchingUrl(url) == null && this.getStrategyForURL(url) != null && this.business.scmCheckoutDirectorySettledUp(this.createScmContext());
    }

    public ScmSyncStrategy getStrategyForURL(String url) {
        for (ScmSyncStrategy strat : AVAILABLE_STRATEGIES) {
            if (!strat.isCurrentUrlApplicable(url)) continue;
            return strat;
        }
        return null;
    }

    public boolean isNoUserCommitMessage() {
        return this.noUserCommitMessage;
    }

    public SCM[] getScms() {
        return SCM.values();
    }

    public void setBusiness(ScmSyncConfigurationBusiness business) {
        this.business = business;
    }

    public ScmSyncConfigurationStatusManager getScmSyncConfigurationStatusManager() {
        return this.business.getScmSyncConfigurationStatusManager();
    }

    public String getScmRepositoryUrl() {
        return this.scmRepositoryUrl;
    }

    public boolean isScmSelected(SCM _scm) {
        return this.scm == _scm;
    }

    public SCM getSCM() {
        return this.scm;
    }

    public String getScmUrl() {
        if (this.scm != null) {
            return this.scm.extractScmUrlFrom(this.scmRepositoryUrl);
        }
        return null;
    }

    public List<File> getFilesModifiedByLastReload() {
        return this.filesModifiedByLastReload;
    }

    public boolean isDisplayStatus() {
        return this.displayStatus;
    }

    public String getCommitMessagePattern() {
        return this.commitMessagePattern;
    }

    public Descriptor<? extends hudson.scm.SCM> getDescriptorForSCM(String scmName) {
        return SCM.valueOf(scmName).getSCMDescriptor();
    }

    public void startThreadedTransaction() {
        this.setTransaction(new ThreadedTransaction(this.synchronousTransactions));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Void> commitChangeset(ChangeSet changeset) {
        try {
            if (!changeset.isEmpty()) {
                Future<Void> future = this.latestCommitFuture = this.business.queueChangeSet(this.createScmContext(), changeset, this.getCurrentUser(), ScmSyncConfigurationDataProvider.retrieveComment(false));
                return future;
            }
            Future<Void> future = null;
            return future;
        }
        finally {
            this.setTransaction(null);
        }
    }

    public ScmTransaction getTransaction() {
        if (this.transaction.get() == null) {
            this.setTransaction(new AtomicTransaction(this.synchronousTransactions));
        }
        return this.transaction.get();
    }

    protected void setTransaction(ScmTransaction transactionToRegister) {
        if (this.transaction.get() != null && transactionToRegister != null) {
            LOGGER.warning("Existing threaded transaction will be overriden !");
        }
        this.transaction.set(transactionToRegister);
    }

    public Future<Void> getLatestCommitFuture() {
        return this.latestCommitFuture;
    }

    public static interface AtomicTransactionFactory {
        public AtomicTransaction createAtomicTransaction();
    }
}

