/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.scm_sync_configuration;

import hudson.plugins.scm_sync_configuration.model.BotherTimeout;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import org.kohsuke.stapler.Stapler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScmSyncConfigurationDataProvider {
    private static final ThreadLocal<HttpServletRequest> CURRENT_REQUEST = new ThreadLocal();
    private static final String COMMENT_SESSION_KEY = "__commitMessage";
    private static final String BOTHER_TIMEOUTS_SESSION_KEY = "__botherTimeouts";

    public static void provideBotherTimeout(String type, int timeoutMinutesFromNow, String currentUrl) {
        Map<BotherTimeout, Date> botherTimeouts = ScmSyncConfigurationDataProvider.retrievePurgedBotherTimeouts();
        if (botherTimeouts == null) {
            botherTimeouts = new HashMap<BotherTimeout, Date>();
        }
        ArrayList<Map.Entry<BotherTimeout, Date>> entriesToDelete = new ArrayList<Map.Entry<BotherTimeout, Date>>();
        for (Map.Entry<BotherTimeout, Date> entry : botherTimeouts.entrySet()) {
            if (!entry.getKey().matchesUrl(currentUrl)) continue;
            entriesToDelete.add(entry);
        }
        botherTimeouts.keySet().removeAll(entriesToDelete);
        Calendar cal = Calendar.getInstance();
        cal.add(12, timeoutMinutesFromNow);
        BotherTimeout bt = BotherTimeout.FACTORY.createBotherTimeout(type, timeoutMinutesFromNow, currentUrl);
        botherTimeouts.put(bt, cal.getTime());
        ScmSyncConfigurationDataProvider.currentRequest().getSession().setAttribute(BOTHER_TIMEOUTS_SESSION_KEY, botherTimeouts);
    }

    public static Date retrieveBotherTimeoutMatchingUrl(String currentURL) {
        Map<BotherTimeout, Date> botherTimeouts = ScmSyncConfigurationDataProvider.retrievePurgedBotherTimeouts();
        Date timeoutMatchingUrl = null;
        if (botherTimeouts != null) {
            for (Map.Entry<BotherTimeout, Date> entry : botherTimeouts.entrySet()) {
                if (!entry.getKey().matchesUrl(currentURL)) continue;
                timeoutMatchingUrl = entry.getValue();
                break;
            }
        }
        return timeoutMatchingUrl;
    }

    protected static Map<BotherTimeout, Date> retrievePurgedBotherTimeouts() {
        Map botherTimeouts = (Map)ScmSyncConfigurationDataProvider.retrieveObject(BOTHER_TIMEOUTS_SESSION_KEY, false);
        if (botherTimeouts != null) {
            ScmSyncConfigurationDataProvider.purgeOutdatedBotherTimeouts(botherTimeouts);
        }
        return botherTimeouts;
    }

    protected static void purgeOutdatedBotherTimeouts(Map<BotherTimeout, Date> botherTimeouts) {
        Date now = Calendar.getInstance().getTime();
        ArrayList<Map.Entry<BotherTimeout, Date>> entriesToDelete = new ArrayList<Map.Entry<BotherTimeout, Date>>();
        for (Map.Entry<BotherTimeout, Date> entry : botherTimeouts.entrySet()) {
            if (!entry.getValue().before(now)) continue;
            entriesToDelete.add(entry);
        }
        botherTimeouts.entrySet().removeAll(entriesToDelete);
    }

    public static void provideComment(String comment) {
        ScmSyncConfigurationDataProvider.currentRequest().getSession().setAttribute(COMMENT_SESSION_KEY, (Object)comment);
    }

    public static String retrieveComment(boolean cleanComment) {
        return (String)ScmSyncConfigurationDataProvider.retrieveObject(COMMENT_SESSION_KEY, cleanComment);
    }

    private static Object retrieveObject(String key, boolean cleanObject) {
        HttpServletRequest request = ScmSyncConfigurationDataProvider.currentRequest();
        Object obj = null;
        if (request != null) {
            obj = request.getSession().getAttribute(key);
            if (cleanObject) {
                request.getSession().removeAttribute(key);
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void provideRequestDuring(HttpServletRequest request, Callable<Void> callable) throws Exception {
        CURRENT_REQUEST.set(request);
        try {
            callable.call();
        }
        finally {
            CURRENT_REQUEST.set(null);
        }
    }

    protected static HttpServletRequest currentRequest() {
        if (Stapler.getCurrentRequest() == null) {
            return CURRENT_REQUEST.get();
        }
        return Stapler.getCurrentRequest();
    }
}

