/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.scm_sync_configuration;

import com.google.common.io.Files;
import hudson.model.Hudson;
import hudson.model.User;
import hudson.plugins.scm_sync_configuration.JenkinsFilesHelper;
import hudson.plugins.scm_sync_configuration.SCMManagerFactory;
import hudson.plugins.scm_sync_configuration.SCMManipulator;
import hudson.plugins.scm_sync_configuration.ScmSyncConfigurationPlugin;
import hudson.plugins.scm_sync_configuration.ScmSyncConfigurationStatusManager;
import hudson.plugins.scm_sync_configuration.exceptions.LoggableException;
import hudson.plugins.scm_sync_configuration.model.ChangeSet;
import hudson.plugins.scm_sync_configuration.model.Commit;
import hudson.plugins.scm_sync_configuration.model.MessageWeight;
import hudson.plugins.scm_sync_configuration.model.Path;
import hudson.plugins.scm_sync_configuration.model.ScmContext;
import hudson.plugins.scm_sync_configuration.model.WeightedMessage;
import hudson.plugins.scm_sync_configuration.strategies.ScmSyncStrategy;
import hudson.plugins.scm_sync_configuration.utils.Checksums;
import hudson.util.DaemonThreadFactory;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.manager.ScmManager;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScmSyncConfigurationBusiness {
    private static final String WORKING_DIRECTORY_PATH = "/scm-sync-configuration/";
    private static final String CHECKOUT_SCM_DIRECTORY = "checkoutConfiguration";
    private static final Logger LOGGER = Logger.getLogger(ScmSyncConfigurationBusiness.class.getName());
    private boolean checkoutSucceeded;
    private SCMManipulator scmManipulator;
    private File checkoutScmDirectory = null;
    private ScmSyncConfigurationStatusManager scmSyncConfigurationStatusManager = null;
    final ExecutorService writer = Executors.newFixedThreadPool(1, (ThreadFactory)new DaemonThreadFactory());
    private List<Commit> commitsQueue = Collections.synchronizedList(new ArrayList());

    public ScmSyncConfigurationStatusManager getScmSyncConfigurationStatusManager() {
        if (this.scmSyncConfigurationStatusManager == null) {
            this.scmSyncConfigurationStatusManager = new ScmSyncConfigurationStatusManager();
        }
        return this.scmSyncConfigurationStatusManager;
    }

    public void init(ScmContext scmContext) throws ComponentLookupException, PlexusContainerException {
        ScmManager scmManager = SCMManagerFactory.getInstance().createScmManager();
        this.scmManipulator = new SCMManipulator(scmManager);
        this.checkoutScmDirectory = new File(ScmSyncConfigurationBusiness.getCheckoutScmDirectoryAbsolutePath());
        this.checkoutSucceeded = false;
        this.initializeRepository(scmContext, false);
    }

    public void initializeRepository(ScmContext scmContext, boolean deleteCheckoutScmDir) {
        if (this.scmManipulator != null && this.scmManipulator.scmConfigurationSettledUp(scmContext, true)) {
            LOGGER.info("Initializing SCM repository for scm-sync-configuration plugin ...");
            if (deleteCheckoutScmDir) {
                this.cleanChekoutScmDirectory();
            }
            if (!this.checkoutScmDirectory.exists()) {
                try {
                    FileUtils.forceMkdir((File)this.checkoutScmDirectory);
                    LOGGER.info("Directory [" + this.checkoutScmDirectory.getAbsolutePath() + "] created !");
                }
                catch (IOException e) {
                    LOGGER.warning("Directory [" + this.checkoutScmDirectory.getAbsolutePath() + "] cannot be created !");
                }
            }
            this.checkoutSucceeded = this.scmManipulator.checkout(this.checkoutScmDirectory);
            if (this.checkoutSucceeded) {
                LOGGER.info("SCM repository initialization done.");
            }
            this.signal("Checkout " + this.checkoutScmDirectory, this.checkoutSucceeded);
        }
    }

    public void cleanChekoutScmDirectory() {
        if (this.checkoutScmDirectory != null && this.checkoutScmDirectory.exists()) {
            LOGGER.info("Deleting old checkout SCM directory ...");
            try {
                FileUtils.forceDelete((File)this.checkoutScmDirectory);
            }
            catch (IOException e) {
                LOGGER.throwing(FileUtils.class.getName(), "forceDelete", e);
                LOGGER.severe("Error while deleting [" + this.checkoutScmDirectory.getAbsolutePath() + "] : " + e.getMessage());
            }
            this.checkoutSucceeded = false;
        }
    }

    public List<File> deleteHierarchy(ScmContext scmContext, Path hierarchyPath) {
        if (this.scmManipulator == null || !this.scmManipulator.scmConfigurationSettledUp(scmContext, false)) {
            return null;
        }
        File rootHierarchyTranslatedInScm = hierarchyPath.getScmFile();
        List<File> filesToCommit = this.scmManipulator.deleteHierarchy(rootHierarchyTranslatedInScm);
        if (hierarchyPath.isDirectory()) {
            try {
                FileUtils.deleteDirectory((File)rootHierarchyTranslatedInScm);
            }
            catch (IOException e) {
                throw new LoggableException("Failed to recursively delete scm directory " + rootHierarchyTranslatedInScm.getAbsolutePath(), FileUtils.class, "deleteDirectory", e);
            }
        }
        this.signal("Delete " + hierarchyPath, filesToCommit != null);
        return filesToCommit;
    }

    public Future<Void> queueChangeSet(ScmContext scmContext, ChangeSet changeset, User user, String userMessage) {
        if (this.scmManipulator == null || !this.scmManipulator.scmConfigurationSettledUp(scmContext, false)) {
            LOGGER.info("Queue of changeset " + changeset.toString() + " aborted (scm manipulator not settled !)");
            return null;
        }
        Commit commit = new Commit(changeset, user, userMessage, scmContext);
        LOGGER.info("Queuing commit " + commit.toString() + " to SCM ...");
        this.commitsQueue.add(commit);
        return this.writer.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ScmSyncConfigurationBusiness.this.processCommitsQueue();
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCommitsQueue() {
        File scmRoot = new File(ScmSyncConfigurationBusiness.getCheckoutScmDirectoryAbsolutePath());
        ArrayList<Commit> currentCommitQueue = new ArrayList<Commit>(this.commitsQueue);
        ArrayList<Commit> checkedInCommits = new ArrayList<Commit>();
        try {
            for (Commit commit : currentCommitQueue) {
                String logMessage = "Processing commit : " + commit.toString();
                LOGGER.info(logMessage);
                ArrayList<File> updatedFiles = new ArrayList<File>();
                for (Map.Entry<Path, byte[]> pathContent : commit.getChangeset().getPathContents().entrySet()) {
                    Path pathRelativeToJenkinsRoot = pathContent.getKey();
                    byte[] content = pathContent.getValue();
                    File fileTranslatedInScm = pathRelativeToJenkinsRoot.getScmFile();
                    if (pathRelativeToJenkinsRoot.isDirectory()) {
                        if (fileTranslatedInScm.exists()) continue;
                        String firstNonExistingParentScmPath = pathRelativeToJenkinsRoot.getFirstNonExistingParentScmPath();
                        try {
                            FileUtils.copyDirectory((File)JenkinsFilesHelper.buildFileFromPathRelativeToHudsonRoot(pathRelativeToJenkinsRoot.getPath()), (File)fileTranslatedInScm);
                        }
                        catch (IOException e) {
                            throw new LoggableException("Error while copying file hierarchy to SCM checkouted directory", FileUtils.class, "copyDirectory", e);
                        }
                        updatedFiles.addAll(this.scmManipulator.addFile(scmRoot, firstNonExistingParentScmPath));
                        continue;
                    }
                    boolean fileTranslatedInScmInitiallyExists = fileTranslatedInScm.exists();
                    boolean fileContentModified = this.writeScmContentOnlyIfItDiffers(pathRelativeToJenkinsRoot, content, fileTranslatedInScm);
                    if (fileTranslatedInScmInitiallyExists) {
                        if (!fileContentModified) continue;
                        updatedFiles.add(fileTranslatedInScm);
                        continue;
                    }
                    updatedFiles.addAll(this.scmManipulator.addFile(scmRoot, pathRelativeToJenkinsRoot.getPath()));
                }
                for (Path path : commit.getChangeset().getPathsToDelete()) {
                    List<File> deletedFiles = this.deleteHierarchy(commit.getScmContext(), path);
                    updatedFiles.addAll(deletedFiles);
                }
                if (updatedFiles.isEmpty()) {
                    LOGGER.info("Empty changeset to commit (no changes found on files) => commit skipped !");
                    continue;
                }
                boolean result = this.scmManipulator.checkinFiles(scmRoot, commit.getMessage());
                if (!result) {
                    throw new LoggableException("Error while checking in file to scm repository", SCMManipulator.class, "checkinFiles");
                }
                LOGGER.info("Commit " + commit.toString() + " pushed to SCM !");
                checkedInCommits.add(commit);
                this.signal(logMessage, true);
            }
        }
        catch (LoggableException e) {
            LOGGER.throwing(e.getClazz().getName(), e.getMethodName(), e);
            LOGGER.severe("Error while processing commit queue : " + e.getMessage());
            this.signal(e.getMessage(), false);
        }
        finally {
            this.commitsQueue.removeAll(checkedInCommits);
        }
    }

    private boolean writeScmContentOnlyIfItDiffers(Path pathRelativeToJenkinsRoot, byte[] content, File fileTranslatedInScm) throws LoggableException {
        boolean scmContentUpdated = false;
        boolean contentDiffer = false;
        try {
            contentDiffer = !Checksums.fileAndByteArrayContentAreEqual(fileTranslatedInScm, content);
        }
        catch (IOException e) {
            throw new LoggableException("Error while checking content checksum", Checksums.class, "fileAndByteArrayContentAreEqual", e);
        }
        if (contentDiffer) {
            this.createScmContent(pathRelativeToJenkinsRoot, content, fileTranslatedInScm);
            scmContentUpdated = true;
        }
        return scmContentUpdated;
    }

    private void createScmContent(Path pathRelativeToJenkinsRoot, byte[] content, File fileTranslatedInScm) throws LoggableException {
        Stack<File> directoriesToCreate = new Stack<File>();
        File directory = fileTranslatedInScm.getParentFile();
        while (!directory.exists()) {
            directoriesToCreate.push(directory);
            directory = directory.getParentFile();
        }
        while (!directoriesToCreate.empty()) {
            directory = (File)directoriesToCreate.pop();
            if (directory.mkdir()) continue;
            throw new LoggableException("Error while creating directory " + directory.getAbsolutePath(), File.class, "mkdir");
        }
        try {
            if (pathRelativeToJenkinsRoot.isDirectory()) {
                if (!fileTranslatedInScm.mkdir()) {
                    throw new LoggableException("Error while creating directory " + fileTranslatedInScm.getAbsolutePath(), File.class, "mkdir");
                }
            } else {
                Files.write((byte[])content, (File)fileTranslatedInScm);
            }
        }
        catch (IOException e) {
            throw new LoggableException("Error while creating file in checkouted directory", Files.class, "write", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synchronizeAllConfigs(ScmSyncStrategy[] availableStrategies) {
        ArrayList<File> filesToSync = new ArrayList<File>();
        for (ScmSyncStrategy strategy : availableStrategies) {
            filesToSync.addAll(strategy.createInitializationSynchronizedFileset());
        }
        ScmSyncConfigurationPlugin plugin = ScmSyncConfigurationPlugin.getInstance();
        plugin.startThreadedTransaction();
        try {
            for (File fileToSync : filesToSync) {
                String hudsonConfigPathRelativeToHudsonRoot = JenkinsFilesHelper.buildPathRelativeToHudsonRoot(fileToSync);
                plugin.getTransaction().defineCommitMessage(new WeightedMessage("Repository initialization", MessageWeight.IMPORTANT));
                plugin.getTransaction().registerPath(hudsonConfigPathRelativeToHudsonRoot);
            }
        }
        finally {
            plugin.getTransaction().commit();
        }
    }

    public boolean scmCheckoutDirectorySettledUp(ScmContext scmContext) {
        return this.scmManipulator != null && this.scmManipulator.scmConfigurationSettledUp(scmContext, false) && this.checkoutSucceeded;
    }

    public List<File> reloadAllFilesFromScm() throws IOException, ScmException {
        this.scmManipulator.update(new File(ScmSyncConfigurationBusiness.getCheckoutScmDirectoryAbsolutePath()));
        return this.syncDirectories(new File(ScmSyncConfigurationBusiness.getCheckoutScmDirectoryAbsolutePath() + File.separator), "");
    }

    private List<File> syncDirectories(File from, String relative) throws IOException {
        ArrayList<File> l = new ArrayList<File>();
        for (File f : from.listFiles()) {
            String newRelative = relative + File.separator + f.getName();
            File jenkinsFile = new File(Hudson.getInstance().getRootDir() + newRelative);
            if (f.getName().equals(this.scmManipulator.getScmSpecificFilename())) continue;
            if (f.isDirectory()) {
                if (!jenkinsFile.exists()) {
                    FileUtils.copyDirectory((File)f, (File)jenkinsFile, (FileFilter)new FileFilter(){

                        public boolean accept(File f) {
                            return !f.getName().equals(ScmSyncConfigurationBusiness.this.scmManipulator.getScmSpecificFilename());
                        }
                    });
                    l.add(jenkinsFile);
                    continue;
                }
                l.addAll(this.syncDirectories(f, newRelative));
                continue;
            }
            if (jenkinsFile.exists() && FileUtils.contentEquals((File)f, (File)jenkinsFile)) continue;
            FileUtils.copyFile((File)f, (File)jenkinsFile);
            l.add(jenkinsFile);
        }
        return l;
    }

    private void signal(String operation, boolean result) {
        if (result) {
            this.getScmSyncConfigurationStatusManager().signalSuccess();
        } else {
            this.getScmSyncConfigurationStatusManager().signalFailed(operation);
        }
    }

    public static String getCheckoutScmDirectoryAbsolutePath() {
        return Hudson.getInstance().getRootDir().getAbsolutePath() + WORKING_DIRECTORY_PATH + CHECKOUT_SCM_DIRECTORY;
    }
}

