/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.gerrit.workflow;

import com.google.gerrit.extensions.api.GerritApi;
import com.google.gerrit.extensions.api.changes.ChangeApi;
import com.google.gerrit.extensions.api.changes.Changes;
import com.google.gerrit.extensions.api.changes.NotifyHandling;
import com.google.gerrit.extensions.api.changes.ReviewInput;
import com.google.gerrit.extensions.restapi.RestApiException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import jenkins.plugins.gerrit.GerritApiBuilder;
import jenkins.plugins.gerrit.GerritChange;
import jenkins.plugins.gerrit.GerritVersion;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class GerritReviewStep
extends Step {
    @Deprecated
    private String label = "Verified";
    @Deprecated
    private int score;
    private Map<String, Integer> labels;
    private String message = "";
    private Optional<NotifyHandling> notify = Optional.empty();

    @DataBoundConstructor
    public GerritReviewStep() {
    }

    private ChangeApi getChangeApi(GerritApi gerritApi, GerritChange change) throws RestApiException {
        Changes changesApi = gerritApi.changes();
        return GerritVersion.isVersionBelow215(gerritApi) ? changesApi.id(change.getChangeId().intValue()) : changesApi.id(change.getProject(), change.getChangeId().intValue());
    }

    @Deprecated
    public int getScore() {
        return this.score;
    }

    @Deprecated
    @DataBoundSetter
    public void setScore(int score) {
        this.score = score;
    }

    public Map<String, Integer> getLabels() {
        return this.labels;
    }

    @DataBoundSetter
    public void setLabels(Map<String, Integer> labels) {
        this.labels = labels;
    }

    public String getMessage() {
        return this.message;
    }

    @DataBoundSetter
    public void setMessage(String message) {
        this.message = message;
    }

    @DataBoundSetter
    public void setNotify(NotifyHandling notify) {
        this.notify = Optional.ofNullable(notify);
    }

    public Optional<NotifyHandling> getNotify() {
        return this.notify;
    }

    @Deprecated
    public String getLabel() {
        return this.label;
    }

    @Deprecated
    @DataBoundSetter
    public void setLabel(String label) {
        this.label = label;
    }

    public StepExecution start(StepContext stepContext) throws Exception {
        return new Execution(stepContext);
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public Set<Class<?>> getRequiredContext() {
            return Collections.emptySet();
        }

        public String getFunctionName() {
            return "gerritReview";
        }

        @Nonnull
        public String getDisplayName() {
            return "Gerrit Review Label";
        }
    }

    public class Execution
    extends SynchronousStepExecution<Void> {
        private final TaskListener listener;
        private final EnvVars envVars;

        protected Execution(StepContext context) throws IOException, InterruptedException {
            super(context);
            this.envVars = (EnvVars)context.get(EnvVars.class);
            this.listener = (TaskListener)this.getContext().get(TaskListener.class);
        }

        protected Void run() throws Exception {
            GerritApi gerritApi = new GerritApiBuilder().stepContext(this.getContext()).requireAuthentication().build();
            if (gerritApi == null) {
                return null;
            }
            GerritChange change = new GerritChange(this.getContext());
            if (change.valid()) {
                ReviewInput reviewInput = new ReviewInput().message(GerritReviewStep.this.message);
                boolean negativeVote = false;
                if (GerritReviewStep.this.labels == null && GerritReviewStep.this.label != null) {
                    GerritReviewStep.this.labels = Collections.singletonMap(GerritReviewStep.this.label, GerritReviewStep.this.score);
                }
                this.listener.getLogger().format("Gerrit review change %d/%d labels %s (%s)%n", change.getChangeId(), change.getRevision(), GerritReviewStep.this.labels, GerritReviewStep.this.message);
                if (GerritReviewStep.this.labels != null) {
                    for (Map.Entry l : GerritReviewStep.this.labels.entrySet()) {
                        reviewInput.label((String)l.getKey(), ((Integer)l.getValue()).intValue());
                        if ((Integer)l.getValue() >= 0) continue;
                        negativeVote = true;
                    }
                }
                reviewInput.drafts = ReviewInput.DraftHandling.PUBLISH;
                reviewInput.tag = "autogenerated:jenkins";
                if (GerritReviewStep.this.notify.isPresent()) {
                    reviewInput.notify = (NotifyHandling)GerritReviewStep.this.notify.get();
                } else if (negativeVote) {
                    reviewInput.notify = NotifyHandling.OWNER;
                }
                GerritReviewStep.this.getChangeApi(gerritApi, change).revision(change.getRevision().intValue()).review(reviewInput);
            }
            return null;
        }
    }
}

