/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.gerrit.workflow;

import com.google.gerrit.extensions.api.GerritApi;
import com.google.gerrit.extensions.api.changes.ChangeApi;
import com.google.gerrit.extensions.api.changes.Changes;
import com.google.gerrit.extensions.api.changes.DraftInput;
import com.google.gerrit.extensions.restapi.RestApiException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import jenkins.plugins.gerrit.GerritApiBuilder;
import jenkins.plugins.gerrit.GerritChange;
import jenkins.plugins.gerrit.GerritVersion;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class GerritCommentStep
extends Step {
    private String path;
    private int line;
    private String message;

    @DataBoundConstructor
    public GerritCommentStep(String path, String message) {
        this.path = path;
        this.message = message;
    }

    public int getLine() {
        return this.line;
    }

    @DataBoundSetter
    public void setLine(int line) {
        this.line = line;
    }

    private ChangeApi getChangeApi(GerritApi gerritApi, GerritChange change) throws RestApiException {
        Changes changesApi = gerritApi.changes();
        return GerritVersion.isVersionBelow215(gerritApi) ? changesApi.id(change.getChangeId().intValue()) : changesApi.id(change.getProject(), change.getChangeId().intValue());
    }

    public StepExecution start(StepContext stepContext) throws Exception {
        return new Execution(stepContext);
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public Set<Class<?>> getRequiredContext() {
            return Collections.emptySet();
        }

        public String getFunctionName() {
            return "gerritComment";
        }

        @Nonnull
        public String getDisplayName() {
            return "Gerrit Review Comment";
        }
    }

    public class Execution
    extends SynchronousStepExecution<Void> {
        private final TaskListener listener;
        private final EnvVars envVars;

        protected Execution(StepContext context) throws IOException, InterruptedException {
            super(context);
            this.envVars = (EnvVars)context.get(EnvVars.class);
            this.listener = (TaskListener)this.getContext().get(TaskListener.class);
        }

        protected Void run() throws Exception {
            GerritApi gerritApi = new GerritApiBuilder().stepContext(this.getContext()).requireAuthentication().build();
            if (gerritApi == null) {
                return null;
            }
            GerritChange change = new GerritChange(this.getContext());
            if (change.valid()) {
                this.listener.getLogger().format("Gerrit review change %d/%d %s=%d (%s)%n", change.getChangeId(), change.getRevision(), GerritCommentStep.this.path, GerritCommentStep.this.line, GerritCommentStep.this.message);
                DraftInput draftInput = new DraftInput();
                draftInput.path = GerritCommentStep.this.path;
                draftInput.line = GerritCommentStep.this.line;
                draftInput.message = GerritCommentStep.this.message;
                GerritCommentStep.this.getChangeApi(gerritApi, change).revision(change.getRevision().intValue()).createDraft(draftInput);
            }
            return null;
        }
    }
}

