/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.gerrit.workflow;

import com.google.gerrit.plugins.checks.api.CheckInput;
import com.google.gerrit.plugins.checks.api.CheckState;
import com.google.gerrit.plugins.checks.client.GerritChecksApi;
import hudson.Extension;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.net.URISyntaxException;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.plugins.gerrit.GerritApiBuilder;
import jenkins.plugins.gerrit.GerritChange;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class GerritCheckStep
extends Step {
    private Map<String, String> checks;
    private String message = "";
    private String url;

    @DataBoundConstructor
    public GerritCheckStep() {
    }

    public Map<String, String> getChecks() {
        return this.checks;
    }

    @DataBoundSetter
    public void setChecks(Map<String, String> checks) {
        this.checks = checks;
    }

    public String getMessage() {
        return this.message;
    }

    @DataBoundSetter
    public void setMessage(String message) {
        this.message = message;
    }

    public String getUrl() {
        return this.url;
    }

    @DataBoundSetter
    public void setUrl(String url) {
        this.url = url;
    }

    public StepExecution start(StepContext stepContext) throws Exception {
        return new Execution(stepContext);
    }

    private String getConsoleLogUri(StepContext stepContext) throws IOException, InterruptedException {
        String rootUrl = Jenkins.getInstance().getRootUrl();
        if (rootUrl == null) {
            throw new NullPointerException("Jenkins URL has to be set in the Jenkins configuration.");
        }
        return rootUrl + ((Run)stepContext.get(Run.class)).getUrl() + "console";
    }

    private CheckInput setCheckTimestamps(CheckInput input, CheckState state) {
        Timestamp now = new Timestamp(System.currentTimeMillis());
        switch (state) {
            case RUNNING: {
                input.started = now;
                break;
            }
            case SUCCESSFUL: 
            case FAILED: {
                input.finished = now;
                break;
            }
        }
        return input;
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public Set<Class<?>> getRequiredContext() {
            return Collections.emptySet();
        }

        public String getFunctionName() {
            return "gerritCheck";
        }

        @Nonnull
        public String getDisplayName() {
            return "Gerrit Review Check";
        }
    }

    public class Execution
    extends SynchronousStepExecution<Void> {
        private final TaskListener listener;
        private final String consoleLogUri;

        protected Execution(StepContext context) throws IOException, InterruptedException, URISyntaxException {
            super(context);
            this.listener = (TaskListener)this.getContext().get(TaskListener.class);
            this.consoleLogUri = GerritCheckStep.this.getConsoleLogUri(context);
        }

        protected Void run() throws Exception {
            GerritChecksApi gerritChecksApi = new GerritApiBuilder().stepContext(this.getContext()).requireAuthentication().buildChecksApi();
            if (gerritChecksApi == null) {
                return null;
            }
            GerritChange change = new GerritChange(this.getContext());
            if (change.valid()) {
                this.listener.getLogger().format("Gerrit review change %d/%d checks %s (%s)%n", change.getChangeId(), change.getRevision(), GerritCheckStep.this.checks, GerritCheckStep.this.message);
                if (GerritCheckStep.this.checks != null) {
                    for (Map.Entry check : GerritCheckStep.this.checks.entrySet()) {
                        CheckInput input = new CheckInput();
                        input.checkerUuid = (String)check.getKey();
                        input.state = CheckState.valueOf((String)check.getValue());
                        input.message = GerritCheckStep.this.message;
                        input.url = GerritCheckStep.this.url != null ? GerritCheckStep.this.url : this.consoleLogUri;
                        input = GerritCheckStep.this.setCheckTimestamps(input, input.state);
                        gerritChecksApi.checks().change(change.getChangeId()).patchSet(change.getRevision()).update(input);
                    }
                }
            }
            return null;
        }
    }
}

