/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.gerrit.traits;

import hudson.Extension;
import hudson.util.ListBoxModel;
import javax.annotation.Nonnull;
import jenkins.plugins.gerrit.GerritSCMSource;
import jenkins.plugins.gerrit.GerritSCMSourceContext;
import jenkins.plugins.gerrit.PendingChecksFilter;
import jenkins.plugins.gerrit.traits.Messages;
import jenkins.plugins.git.GitSCMBuilder;
import jenkins.scm.api.SCMHeadCategory;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.trait.SCMBuilder;
import jenkins.scm.api.trait.SCMSourceContext;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMSourceTraitDescriptor;
import jenkins.scm.impl.trait.Discovery;
import org.kohsuke.stapler.DataBoundConstructor;

public class FilterChecksTrait
extends SCMSourceTrait {
    private final ChecksQueryOperator queryOperator;
    private final String queryString;

    @DataBoundConstructor
    public FilterChecksTrait(ChecksQueryOperator queryOperator, String queryString) {
        this.queryOperator = queryOperator;
        this.queryString = queryString;
    }

    public ChecksQueryOperator getQueryOperator() {
        return this.queryOperator;
    }

    public String getQueryString() {
        return this.queryString;
    }

    protected void decorateContext(SCMSourceContext<?, ?> context) {
        GerritSCMSourceContext ctx = (GerritSCMSourceContext)context;
        ctx.wantFilterForPendingChecks(true);
        ctx.withChecksQueryOperator(this.queryOperator);
        ctx.withChecksQueryString(this.queryString);
        ctx.withFilter(new PendingChecksFilter());
    }

    public boolean includeCategory(@Nonnull SCMHeadCategory category) {
        return category.isUncategorized();
    }

    @Extension
    @Discovery
    public static class DescriptorImpl
    extends SCMSourceTraitDescriptor {
        public String getDisplayName() {
            return Messages.FilterChecksTrait_displayName();
        }

        public ListBoxModel doFillQueryOperatorItems() {
            ListBoxModel items = new ListBoxModel();
            items.add(Messages.FilterChecksTrait_checkerIdOperator(), ChecksQueryOperator.ID.name());
            items.add(Messages.FilterChecksTrait_schemeOperator(), ChecksQueryOperator.SCHEME.name());
            return items;
        }

        public Class<? extends SCMBuilder> getBuilderClass() {
            return GitSCMBuilder.class;
        }

        public Class<? extends SCMSourceContext> getContextClass() {
            return GerritSCMSourceContext.class;
        }

        public Class<? extends SCMSource> getSourceClass() {
            return GerritSCMSource.class;
        }
    }

    public static enum ChecksQueryOperator {
        ID,
        SCHEME;

    }
}

