/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.gerrit.traits;

import hudson.Extension;
import javax.annotation.Nonnull;
import jenkins.plugins.gerrit.GerritSCMSource;
import jenkins.plugins.gerrit.GerritSCMSourceContext;
import jenkins.plugins.gerrit.traits.Messages;
import jenkins.plugins.git.GitSCMBuilder;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadCategory;
import jenkins.scm.api.SCMHeadOrigin;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.trait.SCMBuilder;
import jenkins.scm.api.trait.SCMHeadAuthority;
import jenkins.scm.api.trait.SCMHeadAuthorityDescriptor;
import jenkins.scm.api.trait.SCMSourceContext;
import jenkins.scm.api.trait.SCMSourceRequest;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMSourceTraitDescriptor;
import jenkins.scm.impl.trait.Discovery;
import org.kohsuke.stapler.DataBoundConstructor;

public class ChangeDiscoveryTrait
extends SCMSourceTrait {
    private final String queryString;

    @DataBoundConstructor
    public ChangeDiscoveryTrait(String queryString) {
        this.queryString = queryString;
    }

    public String getQueryString() {
        return this.queryString;
    }

    protected void decorateContext(SCMSourceContext<?, ?> context) {
        GerritSCMSourceContext ctx = (GerritSCMSourceContext)context;
        ctx.wantBranches(true);
        ctx.withAuthority(new BranchSCMHeadAuthority());
        ctx.setChangeFilter(this.queryString);
    }

    public boolean includeCategory(@Nonnull SCMHeadCategory category) {
        return category.isUncategorized();
    }

    public static class BranchSCMHeadAuthority
    extends SCMHeadAuthority<SCMSourceRequest, SCMHead, SCMRevision> {
        protected boolean checkTrusted(@Nonnull SCMSourceRequest request, @Nonnull SCMHead head) {
            return true;
        }

        @Extension
        public static class DescriptorImpl
        extends SCMHeadAuthorityDescriptor {
            public String getDisplayName() {
                return jenkins.plugins.git.traits.Messages.BranchDiscoveryTrait_authorityDisplayName();
            }

            public boolean isApplicableToOrigin(@Nonnull Class<? extends SCMHeadOrigin> originClass) {
                return SCMHeadOrigin.Default.class.isAssignableFrom(originClass);
            }
        }
    }

    @Extension
    @Discovery
    public static class DescriptorImpl
    extends SCMSourceTraitDescriptor {
        public String getDisplayName() {
            return Messages.ChangeDiscoveryTrait_displayName();
        }

        public Class<? extends SCMBuilder> getBuilderClass() {
            return GitSCMBuilder.class;
        }

        public Class<? extends SCMSourceContext> getContextClass() {
            return GerritSCMSourceContext.class;
        }

        public Class<? extends SCMSource> getSourceClass() {
            return GerritSCMSource.class;
        }
    }
}

