/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.gerrit;

import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import hudson.model.TaskListener;
import jenkins.plugins.gerrit.FakeTaskListener;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.URIish;
import org.jenkinsci.plugins.gitclient.trilead.SmartCredentialsProvider;

public class UsernamePasswordCredentialsProvider
extends SmartCredentialsProvider {
    private final StandardUsernameCredentials credentials;

    public UsernamePasswordCredentialsProvider(StandardUsernameCredentials credentials) {
        super((TaskListener)FakeTaskListener.INSTANCE);
        this.credentials = credentials;
    }

    public UsernamePassword getUsernamePassword(URIish uri) {
        this.addDefaultCredentials((StandardCredentials)this.credentials);
        String username = uri.getUser();
        String password = uri.getPass();
        CredentialItem.Username u = new CredentialItem.Username();
        CredentialItem.Password p = new CredentialItem.Password();
        if (this.supports(new CredentialItem[]{u, p}) && this.get(uri, new CredentialItem[]{u, p})) {
            username = u.getValue();
            char[] v = p.getValue();
            password = v == null ? null : new String(p.getValue());
            p.clear();
        }
        return new UsernamePassword(username, password);
    }

    public static class UsernamePassword {
        public final String username;
        public final String password;

        public UsernamePassword(String username, String password) {
            this.username = username;
            this.password = password;
        }
    }
}

