/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.gerrit;

import com.urswolfer.gerrit.client.rest.GerritAuthData;
import com.urswolfer.gerrit.client.rest.http.HttpClientBuilderExtension;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;

class UserAgentClientBuilderExtension
extends HttpClientBuilderExtension {
    static final HttpClientBuilderExtension INSTANCE = new UserAgentClientBuilderExtension();
    private static final Logger LOGGER = Logger.getLogger(UserAgentClientBuilderExtension.class.getName());
    private static String pluginVersion;

    UserAgentClientBuilderExtension() {
    }

    public HttpClientBuilder extend(HttpClientBuilder httpClientBuilder, GerritAuthData authData) {
        HttpClientBuilder builder = super.extend(httpClientBuilder, authData);
        httpClientBuilder.addInterceptorLast((HttpRequestInterceptor)new UserAgentHttpRequestInterceptor());
        return builder;
    }

    private static String getCurrentVersion() {
        if (pluginVersion != null) {
            return pluginVersion;
        }
        ClassLoader pluginClassLoader = UserAgentClientBuilderExtension.class.getClassLoader();
        Optional<Properties> jarProperties = Optional.ofNullable(pluginClassLoader.getResource("META-INF/maven/org.jenkins-ci.plugins/gerrit-code-review/pom.properties")).map(UserAgentClientBuilderExtension::loadProperties);
        return jarProperties.flatMap(p -> Optional.ofNullable((String)p.get("version"))).orElse("(dev)");
    }

    private static Properties loadProperties(URL url) {
        Properties properties = new Properties();
        try {
            try (InputStream is = url.openStream();){
                properties.load(is);
            }
            return properties;
        }
        catch (IOException ioe) {
            LOGGER.log(Level.WARNING, "Unable to extract the current plugin version", ioe);
            return properties;
        }
    }

    private static class UserAgentHttpRequestInterceptor
    implements HttpRequestInterceptor {
        private UserAgentHttpRequestInterceptor() {
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            Header existingUserAgent = request.getFirstHeader("User-Agent");
            String userAgent = String.format("gerrit-code-review-plugin/%s", UserAgentClientBuilderExtension.getCurrentVersion());
            userAgent = userAgent + " using " + existingUserAgent.getValue();
            request.setHeader("User-Agent", userAgent);
        }
    }
}

