/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.gerrit;

import com.google.gerrit.extensions.api.GerritApi;
import com.google.gerrit.extensions.client.ListChangesOption;
import com.google.gerrit.extensions.common.ChangeInfo;
import com.google.gerrit.extensions.restapi.RestApiException;
import java.util.EnumSet;
import java.util.Optional;
import java.util.logging.Logger;
import jenkins.plugins.gerrit.GerritVersion;

class ProjectChanges {
    private static final Logger LOGGER = Logger.getLogger(ProjectChanges.class.getName());
    private final GerritApi gerritApi;

    ProjectChanges(GerritApi gerritApi) {
        this.gerritApi = gerritApi;
    }

    public Optional<ChangeInfo> get(int changeNumber, String projectName) {
        try {
            EnumSet<ListChangesOption> options = EnumSet.allOf(ListChangesOption.class);
            options.remove(ListChangesOption.CHECK);
            if (GerritVersion.isVersionBelow215(this.gerritApi)) {
                options.remove(ListChangesOption.TRACKING_IDS);
                options.remove(ListChangesOption.SKIP_MERGEABLE);
                return Optional.ofNullable(this.gerritApi.changes().id(changeNumber).get(options));
            }
            return Optional.ofNullable(this.gerritApi.changes().id(projectName, changeNumber).get(options));
        }
        catch (RestApiException e) {
            LOGGER.severe(String.format("Unable to retrieve change %d project %s", changeNumber, projectName));
            LOGGER.throwing(ProjectChanges.class.getName(), "get", e);
            return Optional.empty();
        }
    }
}

