/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.gerrit;

import com.google.gerrit.extensions.api.GerritApi;
import com.google.gerrit.extensions.api.projects.Projects;
import com.google.gerrit.extensions.common.ProjectInfo;
import com.google.gerrit.extensions.restapi.RestApiException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class PagedCodeProjectsRequest
implements Iterable<ProjectInfo> {
    private static final int CHUNK_DEFAULT_MAX_SIZE = 20;
    private final GerritApi gerritApi;
    private final int chunkMaxSize;

    public PagedCodeProjectsRequest(GerritApi gerritApi) {
        this(gerritApi, 20);
    }

    public PagedCodeProjectsRequest(GerritApi gerritApi, int chunkMaxSize) {
        this.gerritApi = gerritApi;
        this.chunkMaxSize = chunkMaxSize;
    }

    @Override
    public Iterator<ProjectInfo> iterator() {
        return new ProjectIterator(this.gerritApi, this.chunkMaxSize);
    }

    private static class ProjectIterator
    implements Iterator<ProjectInfo> {
        private final GerritApi gerritApi;
        private final int chunkMaxSize;
        private Projects.ListRequest listRequest;
        private Iterator<ProjectInfo> chunkIterator;
        private boolean moreChunkToFetch = true;

        public ProjectIterator(GerritApi gerritApi, int chunkMaxSize) {
            this.gerritApi = gerritApi;
            this.chunkMaxSize = chunkMaxSize;
        }

        @Override
        public boolean hasNext() {
            return this.getChunkIterator().hasNext();
        }

        @Override
        public ProjectInfo next() {
            return this.getChunkIterator().next();
        }

        private Iterator<ProjectInfo> getChunkIterator() {
            List nextChunk;
            if (this.chunkIterator != null && this.chunkIterator.hasNext()) {
                return this.chunkIterator;
            }
            if (!this.moreChunkToFetch) {
                return Collections.emptyIterator();
            }
            try {
                if (this.listRequest != null) {
                    this.listRequest.withStart(this.listRequest.getStart() + this.chunkMaxSize);
                } else {
                    this.listRequest = this.createListRequest();
                }
                nextChunk = this.listRequest.get();
            }
            catch (RestApiException e) {
                throw new IllegalStateException(e);
            }
            this.moreChunkToFetch = nextChunk.size() >= this.chunkMaxSize;
            this.chunkIterator = nextChunk.iterator();
            return this.chunkIterator;
        }

        private Projects.ListRequest createListRequest() {
            return this.gerritApi.projects().list().withType(Projects.ListRequest.FilterType.CODE).withLimit(this.chunkMaxSize);
        }
    }
}

