/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.gerrit;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import hudson.Extension;
import hudson.model.RootAction;
import hudson.model.UnprotectedRootAction;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.util.Secret;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import jenkins.model.Jenkins;
import jenkins.plugins.gerrit.GerritProjectEvent;
import jenkins.plugins.gerrit.GerritSCMSource;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceOwner;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class GerritWebHook
implements UnprotectedRootAction {
    private static final Logger log = LoggerFactory.getLogger(GerritWebHook.class);
    private static final Gson gson = new Gson();
    public static final String URLNAME = "gerrit-webhook";
    private static final Set<String> ALLOWED_TYPES = Sets.newHashSet((Object[])new String[]{"ref-updated", "change-deleted", "change-abandoned", "change-merged", "change-restored", "patchset-created", "private-state-changed", "wip-state-changed"});

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return URLNAME;
    }

    public void doIndex() throws IOException {
        StaplerRequest req = Stapler.getCurrentRequest();
        String jobName = req.getParameter("jobName");
        boolean isJobNameNullOrEmpty = Strings.isNullOrEmpty((String)jobName);
        String apiKeyParam = req.getParameter("apiKey");
        this.getBody((HttpServletRequest)req).ifPresent(projectEvent -> {
            String username = "anonymous";
            GerritWebHook.getJenkinsInstance();
            Authentication authentication = Jenkins.getAuthentication();
            if (authentication != null) {
                username = authentication.getName();
            }
            log.info("GerritWebHook invoked by user '{}' for event: {}", (Object)username, projectEvent);
            try (ACLContext acl = ACL.as((Authentication)ACL.SYSTEM);){
                List<WorkflowMultiBranchProject> jenkinsItems = GerritWebHook.getJenkinsInstance().getAllItems(WorkflowMultiBranchProject.class).stream().filter(job -> isJobNameNullOrEmpty || job.getName().equals(jobName)).collect(Collectors.toList());
                if (!isJobNameNullOrEmpty) {
                    if (jenkinsItems.isEmpty()) {
                        log.error("Job '{}' not found or not a multi-branch pipeline", (Object)jobName);
                        return;
                    }
                    if (jenkinsItems.size() > 1) {
                        log.error("Search for job '{}' is ambiguous and returned {} entries", (Object)jobName, (Object)jenkinsItems.size());
                        return;
                    }
                }
                log.info("Scanning {} Jenkins items {}", (Object)jenkinsItems.size(), (Object)(jobName == null ? "" : "matching " + jobName));
                jenkinsItems.forEach(scmJob -> scmJob.getSCMSources().stream().filter(GerritSCMSource.class::isInstance).map(GerritSCMSource.class::cast).forEach(scmSource -> this.triggerScmSourceOnJob(apiKeyParam, (GerritProjectEvent)projectEvent, (SCMSourceOwner)scmJob, (GerritSCMSource)((Object)((Object)((Object)scmSource))))));
            }
        });
    }

    private void triggerScmSourceOnJob(String apiKeyParam, GerritProjectEvent projectEvent, SCMSourceOwner scmJob, GerritSCMSource gerritSCMSource) {
        Secret gerritSCMSourceApiKey = gerritSCMSource.getApiKey();
        log.debug("Checking match for SCM source: " + gerritSCMSource.getRemote());
        if (!projectEvent.matches(gerritSCMSource.getRemote())) {
            log.warn("Not triggering job {}: SCM source remote does not match the one specified in the project event", (Object)scmJob.getName());
            return;
        }
        if (Secret.toString((Secret)gerritSCMSourceApiKey).isEmpty()) {
            log.debug("The apiKey secret was not configured in the SCM source or empty");
        } else if (!Objects.equals(apiKeyParam, gerritSCMSourceApiKey.getPlainText())) {
            log.error("Unable to trigger the SCM source because of the ApiKey provided in gerrit web-hook does not match the one configured in the source");
            return;
        }
        log.info("Triggering SCM event for source {} on job {}", (Object)gerritSCMSource, (Object)scmJob);
        scmJob.onSCMSourceUpdated((SCMSource)gerritSCMSource);
    }

    @VisibleForTesting
    Optional<GerritProjectEvent> getBody(HttpServletRequest req) throws IOException {
        try (InputStreamReader is = new InputStreamReader((InputStream)req.getInputStream(), StandardCharsets.UTF_8);){
            JsonObject eventJson = (JsonObject)gson.fromJson((Reader)is, JsonObject.class);
            JsonPrimitive eventType = eventJson.getAsJsonPrimitive("type");
            if (eventType != null && ALLOWED_TYPES.contains(eventType.getAsString())) {
                Optional<Object> optional = Optional.of(gson.fromJson((JsonElement)eventJson, GerritProjectEvent.class));
                return optional;
            }
            Optional<GerritProjectEvent> optional = Optional.empty();
            return optional;
        }
    }

    public static GerritWebHook get() {
        return (GerritWebHook)Jenkins.getInstance().getExtensionList(RootAction.class).get(GerritWebHook.class);
    }

    @Nonnull
    public static Jenkins getJenkinsInstance() throws IllegalStateException {
        return Jenkins.getInstance();
    }
}

