/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.gerrit;

import com.google.gerrit.extensions.api.GerritApi;
import com.google.gerrit.extensions.restapi.RestApiException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GerritVersion {
    private static final Logger LOGGER = Logger.getLogger(GerritVersion.class.getName());

    public static boolean isVersionBelow215(GerritApi gerritApi) throws RestApiException {
        String version = gerritApi.config().server().getVersion();
        if (version == null) {
            return false;
        }
        if (version.equals("<2.8")) {
            return true;
        }
        String[] versionSplit = version.split("\\.");
        if (versionSplit.length == 0) {
            return false;
        }
        try {
            int majorVersion = Integer.parseInt(versionSplit[0]);
            if (majorVersion < 2) {
                return true;
            }
            if (majorVersion > 2) {
                return false;
            }
            if (versionSplit.length < 2) {
                return true;
            }
            int minorVersion = Integer.parseInt(versionSplit[1]);
            return minorVersion < 15;
        }
        catch (NumberFormatException e) {
            LOGGER.log(Level.SEVERE, "Unable to parse Gerrit version " + version, e);
            return false;
        }
    }
}

