/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.gerrit;

import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jgit.transport.URIish;

public class GerritURI {
    private static final Pattern GERRIT_AUTH_HTTP_URI_PATTERN = Pattern.compile("(.*?)/a/(.*)(\\.git)?");
    private static final Pattern GERRIT_ANON_HTTP_URI_PATTERN = Pattern.compile("(/)(.*(?<!\\.git))(\\.git)?");
    private final URIish remoteURI;

    public GerritURI(URIish remoteURI) {
        this.remoteURI = remoteURI;
    }

    public URIish getRemoteURI() {
        return this.remoteURI;
    }

    public String getProject() {
        Scheme scheme = this.getScheme(this.remoteURI.getScheme());
        switch (scheme) {
            case HTTP: 
            case HTTPS: {
                Matcher matcher = this.getMatcher();
                if (!matcher.matches()) {
                    throw new IllegalArgumentException("Unable to determine Gerrit project from remote " + this.remoteURI);
                }
                return matcher.group(2);
            }
            case SSH: {
                return this.remoteURI.getRawPath().substring(1);
            }
        }
        throw new IllegalStateException("Unknown scheme " + (Object)((Object)scheme));
    }

    public String getPrefix() {
        Scheme scheme = this.getScheme(this.remoteURI.getScheme());
        switch (scheme) {
            case HTTP: 
            case HTTPS: {
                Matcher matcher = this.getMatcher();
                if (!matcher.matches()) {
                    throw new IllegalArgumentException("Unable to determine Gerrit prefix from remote " + this.remoteURI);
                }
                return matcher.group(1);
            }
            case SSH: {
                return "";
            }
        }
        throw new IllegalStateException("Unknown scheme " + (Object)((Object)scheme));
    }

    public URIish getApiURI() throws URISyntaxException {
        return this.remoteURI.setRawPath(this.getPrefix());
    }

    public URIish setPath(String path) {
        return this.remoteURI.setPath(this.getPrefix() + path);
    }

    public URIish setProject(String projectName) throws URISyntaxException {
        return this.remoteURI.setRawPath(this.getPrefix() + projectName);
    }

    private Matcher getMatcher() {
        Matcher authMatcher;
        String rawPath = this.remoteURI.getRawPath();
        if ("".equals(rawPath)) {
            rawPath = "/";
        }
        if ((authMatcher = GERRIT_AUTH_HTTP_URI_PATTERN.matcher(rawPath)).matches()) {
            return authMatcher;
        }
        return GERRIT_ANON_HTTP_URI_PATTERN.matcher(rawPath);
    }

    private Scheme getScheme(String value) {
        for (Scheme scheme : Scheme.values()) {
            if (!scheme.name().equalsIgnoreCase(value)) continue;
            return scheme;
        }
        throw new IllegalArgumentException("Unknown scheme " + value);
    }

    private static enum Scheme {
        HTTP,
        HTTPS,
        SSH;

    }
}

