/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.gerrit;

import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.plugins.checks.api.PendingChecksInfo;
import com.google.gerrit.plugins.checks.client.GerritChecksApi;
import hudson.model.TaskListener;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import jenkins.plugins.gerrit.GerritSCMSource;
import jenkins.plugins.gerrit.GerritSCMSourceContext;
import jenkins.plugins.gerrit.GerritURI;
import jenkins.plugins.git.GitSCMSourceContext;
import jenkins.plugins.git.GitSCMSourceRequest;
import jenkins.scm.api.SCMSource;
import org.eclipse.jgit.transport.URIish;

public class GerritSCMSourceRequest
extends GitSCMSourceRequest {
    private final boolean filterForPendingChecks;
    private final Map<String, HashSet<PendingChecksInfo>> patchsetWithPendingChecks;

    public GerritSCMSourceRequest(GerritSCMSource source, GerritSCMSourceContext context, TaskListener listener) {
        super((SCMSource)source, (GitSCMSourceContext)context, listener);
        this.filterForPendingChecks = context.filterForPendingChecks();
        this.patchsetWithPendingChecks = this.filterForPendingChecks ? this.getChangesWithPendingChecks(source, context, listener) : new HashMap<String, HashSet<PendingChecksInfo>>();
    }

    public Map<String, HashSet<PendingChecksInfo>> getPatchsetWithPendingChecks() {
        return this.patchsetWithPendingChecks;
    }

    private GerritChecksApi getGerritChecksApi(GerritSCMSource source, TaskListener listener) throws IOException {
        try {
            return source.createGerritChecksApi(listener, new GerritURI(new URIish(source.getRemote())));
        }
        catch (IOException | URISyntaxException e) {
            throw new IOException(e);
        }
    }

    private HashMap<String, HashSet<PendingChecksInfo>> getChangesWithPendingChecks(GerritSCMSource source, GerritSCMSourceContext context, TaskListener listener) {
        HashMap<String, HashSet<PendingChecksInfo>> patchsetWithPendingChecks = new HashMap<String, HashSet<PendingChecksInfo>>();
        List<Object> pendingChecks = new ArrayList();
        try {
            GerritChecksApi gerritChecksApi = this.getGerritChecksApi(source, listener);
            switch (context.checksQueryOperator()) {
                case ID: {
                    pendingChecks = gerritChecksApi.pendingChecks().checker(context.checksQueryString()).list();
                    break;
                }
                case SCHEME: {
                    pendingChecks = gerritChecksApi.pendingChecks().scheme(context.checksQueryString()).list();
                    break;
                }
                default: {
                    throw new IOException("Unknown query operator for querying pending checks.");
                }
            }
        }
        catch (RestApiException | IOException | URISyntaxException e) {
            listener.getLogger().println("Unable to query for pending checks: " + e);
        }
        for (PendingChecksInfo check : pendingChecks) {
            if (check.patchSet == null) continue;
            String ref = String.format("%d/%d", check.patchSet.changeNumber, check.patchSet.patchSetId);
            HashSet<Object> checks = new HashSet<PendingChecksInfo>();
            if (patchsetWithPendingChecks.containsKey(ref)) {
                checks = patchsetWithPendingChecks.get(ref);
                checks.add(check);
            } else {
                checks.add(check);
            }
            patchsetWithPendingChecks.put(ref, checks);
        }
        return patchsetWithPendingChecks;
    }
}

