/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.gerrit;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.TaskListener;
import jenkins.plugins.gerrit.GerritSCMSource;
import jenkins.plugins.gerrit.GerritSCMSourceRequest;
import jenkins.plugins.gerrit.traits.FilterChecksTrait;
import jenkins.plugins.git.GitSCMSourceContext;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;

public class GerritSCMSourceContext
extends GitSCMSourceContext<GerritSCMSourceContext, GerritSCMSourceRequest> {
    @NonNull
    private FilterChecksTrait.ChecksQueryOperator checksQueryOperator = FilterChecksTrait.ChecksQueryOperator.SCHEME;
    @NonNull
    private boolean filterForPendingChecks = false;
    @NonNull
    private String checksQueryString = "";
    @NonNull
    private String changesQueryFilter = "";

    public GerritSCMSourceContext(SCMSourceCriteria criteria, SCMHeadObserver observer) {
        super(criteria, observer);
    }

    @NonNull
    public GerritSCMSourceContext wantFilterForPendingChecks(boolean wantFilter) {
        this.filterForPendingChecks = wantFilter;
        return this;
    }

    @NonNull
    public final boolean filterForPendingChecks() {
        return this.filterForPendingChecks;
    }

    @NonNull
    public GerritSCMSourceContext withChecksQueryOperator(FilterChecksTrait.ChecksQueryOperator queryOperator) {
        this.checksQueryOperator = queryOperator;
        return this;
    }

    @NonNull
    public final FilterChecksTrait.ChecksQueryOperator checksQueryOperator() {
        return this.checksQueryOperator;
    }

    @NonNull
    public GerritSCMSourceContext withChecksQueryString(String queryString) {
        this.checksQueryString = queryString;
        return this;
    }

    @NonNull
    public final String checksQueryString() {
        return this.checksQueryString;
    }

    @NonNull
    public GerritSCMSourceRequest newRequest(@NonNull SCMSource source, @CheckForNull TaskListener listener) {
        return new GerritSCMSourceRequest((GerritSCMSource)source, this, listener);
    }

    public void setChangeFilter(String changesQueryFilter) {
        this.changesQueryFilter = changesQueryFilter;
    }

    public String changesQueryFilter() {
        return this.changesQueryFilter;
    }
}

