/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.gerrit;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.net.URISyntaxException;
import javax.annotation.CheckForNull;
import jenkins.plugins.gerrit.GerritSCMSource;
import jenkins.plugins.gerrit.GerritURI;
import jenkins.scm.api.trait.SCMSourceBuilder;
import org.eclipse.jgit.transport.URIish;

public class GerritSCMSourceBuilder
extends SCMSourceBuilder<GerritSCMSourceBuilder, GerritSCMSource> {
    private final String id;
    private final GerritURI gerritURI;
    private final boolean insecureHttps;
    @CheckForNull
    private final String credentialsId;

    public GerritSCMSourceBuilder(String id, @NonNull String projectName, GerritURI gerritURI, boolean insecureHttps, @CheckForNull String credentialsId) {
        super(GerritSCMSource.class, projectName);
        this.id = id;
        this.gerritURI = gerritURI;
        this.insecureHttps = insecureHttps;
        this.credentialsId = credentialsId;
    }

    @NonNull
    public GerritSCMSource build() {
        URIish projectUri;
        try {
            projectUri = this.gerritURI.setProject(this.projectName());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
        GerritSCMSource scmSource = new GerritSCMSource(projectUri.toString());
        scmSource.setId(this.id);
        scmSource.setCredentialsId(this.credentialsId);
        scmSource.setInsecureHttps(this.insecureHttps);
        scmSource.setTraits(this.traits());
        return scmSource;
    }
}

