/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.gerrit;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ParameterValue;
import hudson.model.Queue;
import hudson.model.queue.Tasks;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.GitStatus;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.plugins.git.extensions.GitSCMExtension;
import hudson.plugins.git.extensions.GitSCMExtensionDescriptor;
import hudson.scm.RepositoryBrowser;
import hudson.scm.SCM;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import jenkins.plugins.gerrit.AbstractGerritSCMSource;
import jenkins.plugins.gerrit.GerritSCMSourceContext;
import jenkins.plugins.gerrit.Messages;
import jenkins.plugins.gerrit.traits.ChangeDiscoveryTrait;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.plugins.git.GitSCMBuilder;
import jenkins.plugins.git.traits.GitBrowserSCMSourceTrait;
import jenkins.plugins.git.traits.GitSCMExtensionTrait;
import jenkins.plugins.git.traits.GitSCMExtensionTraitDescriptor;
import jenkins.plugins.git.traits.GitToolSCMSourceTrait;
import jenkins.plugins.git.traits.IgnoreOnPushNotificationTrait;
import jenkins.plugins.git.traits.RefSpecsSCMSourceTrait;
import jenkins.plugins.git.traits.RemoteNameSCMSourceTrait;
import jenkins.scm.api.SCMEvent;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadCategory;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMNavigator;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceDescriptor;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.api.SCMSourceOwners;
import jenkins.scm.api.trait.SCMHeadPrefilter;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMSourceTraitDescriptor;
import jenkins.scm.api.trait.SCMTrait;
import jenkins.scm.impl.ChangeRequestSCMHeadCategory;
import jenkins.scm.impl.UncategorizedSCMHeadCategory;
import jenkins.scm.impl.form.NamedArrayList;
import jenkins.scm.impl.trait.Discovery;
import jenkins.scm.impl.trait.Selection;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.URIish;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class GerritSCMSource
extends AbstractGerritSCMSource {
    private static final String DEFAULT_INCLUDES = "*";
    private static final String DEFAULT_EXCLUDES = "";
    public static final Logger LOGGER = Logger.getLogger(GerritSCMSource.class.getName());
    private final String remote;
    private Boolean insecureHttps;
    private Secret apiKey;
    @CheckForNull
    private String credentialsId;
    private List<SCMSourceTrait> traits = new ArrayList<SCMSourceTrait>();

    @DataBoundConstructor
    public GerritSCMSource(String remote) {
        this.remote = remote;
    }

    @DataBoundSetter
    public void setInsecureHttps(Boolean insecureHttps) {
        this.insecureHttps = insecureHttps;
    }

    @DataBoundSetter
    public void setCredentialsId(@CheckForNull String credentialsId) {
        this.credentialsId = credentialsId;
    }

    @DataBoundSetter
    public void setTraits(List<SCMSourceTrait> traits) {
        this.traits = SCMTrait.asSetList(traits);
    }

    private RefSpecsSCMSourceTrait asRefSpecsSCMSourceTrait(String rawRefSpecs, String remoteName) {
        if (rawRefSpecs != null) {
            HashSet<String> defaults = new HashSet<String>();
            defaults.add("+refs/heads/*:refs/remotes/origin/*");
            if (remoteName != null) {
                defaults.add("+refs/heads/*:refs/remotes/" + remoteName + "/*");
            }
            if (!defaults.contains(rawRefSpecs.trim())) {
                ArrayList<String> templates = new ArrayList<String>();
                for (String rawRefSpec : rawRefSpecs.split(" ")) {
                    if (StringUtils.isBlank((String)rawRefSpec)) continue;
                    if (defaults.contains(rawRefSpec)) {
                        templates.add("+refs/heads/*:refs/remotes/@{remote}/*");
                        continue;
                    }
                    templates.add(rawRefSpec);
                }
                if (!templates.isEmpty()) {
                    return new RefSpecsSCMSourceTrait(templates.toArray(new String[templates.size()]));
                }
            }
        }
        return null;
    }

    @Restricted(value={DoNotUse.class})
    public boolean isIgnoreOnPushNotifications() {
        return SCMTrait.find(this.traits, IgnoreOnPushNotificationTrait.class) != null;
    }

    @DataBoundSetter
    @Restricted(value={DoNotUse.class})
    public void setBrowser(GitRepositoryBrowser browser) {
        ArrayList<SCMSourceTrait> traits = new ArrayList<SCMSourceTrait>(this.traits);
        Iterator iterator = traits.iterator();
        while (iterator.hasNext()) {
            if (!(iterator.next() instanceof GitBrowserSCMSourceTrait)) continue;
            iterator.remove();
        }
        if (browser != null) {
            traits.add((SCMSourceTrait)new GitBrowserSCMSourceTrait(browser));
        }
        this.setTraits(traits);
    }

    @DataBoundSetter
    @Restricted(value={DoNotUse.class})
    public void setGitTool(String gitTool) {
        ArrayList<SCMSourceTrait> traits = new ArrayList<SCMSourceTrait>(this.traits);
        gitTool = Util.fixEmptyAndTrim((String)gitTool);
        Iterator iterator = traits.iterator();
        while (iterator.hasNext()) {
            if (!(iterator.next() instanceof GitToolSCMSourceTrait)) continue;
            iterator.remove();
        }
        if (gitTool != null) {
            traits.add((SCMSourceTrait)new GitToolSCMSourceTrait(gitTool));
        }
        this.setTraits(traits);
    }

    @DataBoundSetter
    @Restricted(value={DoNotUse.class})
    public void setExtensions(@CheckForNull List<GitSCMExtension> extensions) {
        ArrayList<SCMSourceTrait> traits = new ArrayList<SCMSourceTrait>(this.traits);
        Iterator iterator = traits.iterator();
        while (iterator.hasNext()) {
            if (!(iterator.next() instanceof GitSCMExtensionTrait)) continue;
            iterator.remove();
        }
        block3: for (GitSCMExtension extension : Util.fixNull(extensions)) {
            for (SCMSourceTraitDescriptor d : SCMSourceTrait.all()) {
                GitSCMExtensionTraitDescriptor descriptor;
                if (d instanceof GitSCMExtensionTraitDescriptor && (descriptor = (GitSCMExtensionTraitDescriptor)d).getExtensionClass().isInstance(extension)) {
                    try {
                        SCMSourceTrait trait = descriptor.convertToTrait(extension);
                        if (trait != null) {
                            traits.add(trait);
                            continue block3;
                        }
                    }
                    catch (UnsupportedOperationException e) {
                        LOGGER.log(Level.WARNING, "Could not convert " + extension.getClass().getName() + " to a trait", e);
                    }
                }
                LOGGER.log(Level.FINE, "Could not convert {0} to a trait (likely because this option does not make sense for a GitSCMSource)", extension.getClass().getName());
            }
        }
        this.setTraits(traits);
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String getRemote() {
        return this.remote;
    }

    @Override
    public Boolean getInsecureHttps() {
        return this.insecureHttps;
    }

    @Restricted(value={DoNotUse.class})
    public String getRawRefSpecs() {
        String remoteName = null;
        RefSpecsSCMSourceTrait refSpecs = null;
        for (SCMSourceTrait trait : this.traits) {
            if (trait instanceof RemoteNameSCMSourceTrait) {
                remoteName = ((RemoteNameSCMSourceTrait)trait).getRemoteName();
                if (refSpecs != null) break;
            }
            if (!(trait instanceof RefSpecsSCMSourceTrait)) continue;
            refSpecs = (RefSpecsSCMSourceTrait)trait;
            if (remoteName == null) continue;
            break;
        }
        if (remoteName == null) {
            remoteName = "origin";
        }
        if (refSpecs == null) {
            return "+refs/heads/*:refs/remotes/@{remote}/*".replaceAll(AbstractGitSCMSource.REF_SPEC_REMOTE_NAME_PLACEHOLDER, remoteName);
        }
        StringBuilder result = new StringBuilder();
        boolean first = true;
        Pattern placeholder = Pattern.compile(AbstractGitSCMSource.REF_SPEC_REMOTE_NAME_PLACEHOLDER);
        for (String template : refSpecs.asStrings()) {
            if (first) {
                first = false;
            } else {
                result.append(' ');
            }
            result.append(placeholder.matcher(template).replaceAll(remoteName));
        }
        return result.toString();
    }

    @Restricted(value={DoNotUse.class})
    protected List<RefSpec> getRefSpecs() {
        return ((GerritSCMSourceContext)new GerritSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(this.traits)).asRefSpecs();
    }

    @Nonnull
    public List<SCMSourceTrait> getTraits() {
        return this.traits;
    }

    @DataBoundSetter
    public void setApiKey(Secret apiKey) {
        this.apiKey = apiKey;
    }

    public Secret getApiKey() {
        return this.apiKey;
    }

    @Extension
    public static class ListenerImpl
    extends GitStatus.Listener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<GitStatus.ResponseContributor> onNotifyCommit(String origin, URIish uri, final @Nullable String sha1, List<ParameterValue> buildParameters, String ... branches) {
            boolean[] notified;
            ArrayList<GitStatus.ResponseContributor> result;
            block10: {
                result = new ArrayList<GitStatus.ResponseContributor>();
                notified = new boolean[]{false};
                Jenkins jenkins = Jenkins.getInstance();
                jenkins.getACL();
                SecurityContext old = ACL.impersonate((Authentication)ACL.SYSTEM);
                try {
                    if (branches.length > 0) {
                        final URIish u = uri;
                        for (final String branch : branches) {
                            SCMHeadEvent.fireNow((SCMHeadEvent)new SCMHeadEvent<String>(SCMEvent.Type.UPDATED, branch, origin){

                                public boolean isMatch(@Nonnull SCMNavigator navigator) {
                                    return false;
                                }

                                @Nonnull
                                public String getSourceName() {
                                    return u.getHumanishName();
                                }

                                public boolean isMatch(SCMSource source) {
                                    if (source instanceof GerritSCMSource) {
                                        URIish remote;
                                        GerritSCMSource git = (GerritSCMSource)source;
                                        GerritSCMSourceContext ctx = (GerritSCMSourceContext)new GerritSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(git.getTraits());
                                        if (ctx.ignoreOnPushNotifications()) {
                                            return false;
                                        }
                                        try {
                                            remote = new URIish(git.getRemote());
                                        }
                                        catch (URISyntaxException e) {
                                            return false;
                                        }
                                        if (GitStatus.looselyMatches((URIish)u, (URIish)remote)) {
                                            notified[0] = true;
                                            return true;
                                        }
                                        return false;
                                    }
                                    return false;
                                }

                                @Nonnull
                                public Map<SCMHead, SCMRevision> heads(@Nonnull SCMSource source) {
                                    if (source instanceof GerritSCMSource) {
                                        URIish remote;
                                        GerritSCMSource git = (GerritSCMSource)source;
                                        GerritSCMSourceContext ctx = (GerritSCMSourceContext)new GerritSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(git.getTraits());
                                        if (ctx.ignoreOnPushNotifications()) {
                                            return Collections.emptyMap();
                                        }
                                        try {
                                            remote = new URIish(git.getRemote());
                                        }
                                        catch (URISyntaxException e) {
                                            return Collections.emptyMap();
                                        }
                                        if (GitStatus.looselyMatches((URIish)u, (URIish)remote)) {
                                            SCMHead head = new SCMHead(branch);
                                            for (SCMHeadPrefilter filter : ctx.prefilters()) {
                                                if (!filter.isExcluded((SCMSource)git, head)) continue;
                                                return Collections.emptyMap();
                                            }
                                            return Collections.singletonMap(head, sha1 != null ? new AbstractGitSCMSource.SCMRevisionImpl(head, sha1) : null);
                                        }
                                    }
                                    return Collections.emptyMap();
                                }

                                public boolean isMatch(@Nonnull SCM scm) {
                                    return false;
                                }
                            });
                        }
                        break block10;
                    }
                    for (final SCMSourceOwner owner : SCMSourceOwners.all()) {
                        for (SCMSource source : owner.getSCMSources()) {
                            URIish remote;
                            if (!(source instanceof GerritSCMSource)) continue;
                            GerritSCMSource git = (GerritSCMSource)source;
                            GerritSCMSourceContext ctx = (GerritSCMSourceContext)new GerritSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(git.getTraits());
                            if (ctx.ignoreOnPushNotifications()) continue;
                            try {
                                remote = new URIish(git.getRemote());
                            }
                            catch (URISyntaxException e) {
                                continue;
                            }
                            if (!GitStatus.looselyMatches((URIish)uri, (URIish)remote)) continue;
                            LOGGER.info("Triggering the indexing of " + owner.getFullDisplayName() + " as a result of event from " + origin);
                            owner.onSCMSourceUpdated(source);
                            result.add(new GitStatus.ResponseContributor(){

                                public void addHeaders(StaplerRequest req, StaplerResponse rsp) {
                                    rsp.addHeader("Triggered", owner.getAbsoluteUrl());
                                }

                                public void writeBody(PrintWriter w) {
                                    w.println("Scheduled indexing of " + owner.getFullDisplayName());
                                }
                            });
                            notified[0] = true;
                        }
                    }
                }
                finally {
                    SecurityContextHolder.setContext((SecurityContext)old);
                }
            }
            if (!notified[0]) {
                result.add((GitStatus.ResponseContributor)new GitStatus.MessageResponseContributor("No Git consumers using SCM API plugin for: " + uri.toString()));
            }
            return result;
        }
    }

    @Symbol(value={"gerrit", "git"})
    @Extension
    public static class DescriptorImpl
    extends SCMSourceDescriptor {
        public String getDisplayName() {
            return Messages.GerritSCMSource_DisplayName();
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item context, @QueryParameter String remote, @QueryParameter String credentialsId) {
            if (context == null && !Jenkins.getActiveInstance().hasPermission(Jenkins.ADMINISTER) || context != null && !context.hasPermission(Item.EXTENDED_READ)) {
                return new StandardListBoxModel().includeCurrentValue(credentialsId);
            }
            return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(context instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)context)) : ACL.SYSTEM, context, StandardUsernameCredentials.class, URIRequirementBuilder.fromUri((String)remote).build(), GitClient.CREDENTIALS_MATCHER).includeCurrentValue(credentialsId);
        }

        public FormValidation doCheckCredentialsId(@AncestorInPath Item context, @QueryParameter String remote, @QueryParameter String value) {
            if (context == null && !Jenkins.getActiveInstance().hasPermission(Jenkins.ADMINISTER) || context != null && !context.hasPermission(Item.EXTENDED_READ)) {
                return FormValidation.ok();
            }
            if ((value = Util.fixEmptyAndTrim((String)value)) == null) {
                return FormValidation.ok();
            }
            if ((remote = Util.fixEmptyAndTrim((String)remote)) == null) {
                return FormValidation.ok();
            }
            for (ListBoxModel.Option o : CredentialsProvider.listCredentials(StandardUsernameCredentials.class, (Item)context, (Authentication)(context instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)context)) : ACL.SYSTEM), (List)URIRequirementBuilder.fromUri((String)remote).build(), (CredentialsMatcher)GitClient.CREDENTIALS_MATCHER)) {
                if (!StringUtils.equals((String)value, (String)o.value)) continue;
                return FormValidation.ok();
            }
            return FormValidation.warning((String)("Cannot find any credentials with id " + value));
        }

        @Restricted(value={NoExternalUse.class})
        public GitSCM.DescriptorImpl getSCMDescriptor() {
            return (GitSCM.DescriptorImpl)Jenkins.getActiveInstance().getDescriptor(GitSCM.class);
        }

        @Restricted(value={DoNotUse.class})
        public List<GitSCMExtensionDescriptor> getExtensionDescriptors() {
            return this.getSCMDescriptor().getExtensionDescriptors();
        }

        @Restricted(value={DoNotUse.class})
        public List<Descriptor<RepositoryBrowser<?>>> getBrowserDescriptors() {
            return this.getSCMDescriptor().getBrowserDescriptors();
        }

        @Restricted(value={DoNotUse.class})
        public boolean showGitToolOptions() {
            return this.getSCMDescriptor().showGitToolOptions();
        }

        @Restricted(value={DoNotUse.class})
        public ListBoxModel doFillGitToolItems() {
            return this.getSCMDescriptor().doFillGitToolItems();
        }

        public List<NamedArrayList<? extends SCMSourceTraitDescriptor>> getTraitsDescriptorLists() {
            ArrayList<NamedArrayList<? extends SCMSourceTraitDescriptor>> result = new ArrayList<NamedArrayList<? extends SCMSourceTraitDescriptor>>();
            List descriptors = SCMSourceTrait._for((SCMSourceDescriptor)this, GerritSCMSourceContext.class, GitSCMBuilder.class);
            NamedArrayList.select((List)descriptors, (String)"Within Repository", (NamedArrayList.Predicate)NamedArrayList.anyOf((NamedArrayList.Predicate[])new NamedArrayList.Predicate[]{NamedArrayList.withAnnotation(Selection.class), NamedArrayList.withAnnotation(Discovery.class)}), (boolean)true, result);
            NamedArrayList.select((List)descriptors, (String)"Additional", null, (boolean)true, result);
            return result;
        }

        public List<SCMSourceTrait> getTraitsDefaults() {
            return Arrays.asList(new SCMSourceTrait[]{new ChangeDiscoveryTrait(null), new RefSpecsSCMSourceTrait(new String[]{"+refs/heads/*:refs/remotes/@{remote}/*"})});
        }

        @Nonnull
        protected SCMHeadCategory[] createCategories() {
            return new SCMHeadCategory[]{UncategorizedSCMHeadCategory.DEFAULT, new ChangeRequestSCMHeadCategory(Messages._GerritSCMSource_ChangeRequestCategory())};
        }
    }
}

