/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.gerrit;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.google.gerrit.extensions.api.GerritApi;
import com.google.gerrit.extensions.common.ProjectInfo;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.Queue;
import hudson.model.queue.Tasks;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.plugins.gerrit.GerritApiBuilder;
import jenkins.plugins.gerrit.GerritSCMNavigatorContext;
import jenkins.plugins.gerrit.GerritSCMNavigatorRequest;
import jenkins.plugins.gerrit.GerritSCMSource;
import jenkins.plugins.gerrit.GerritSCMSourceBuilder;
import jenkins.plugins.gerrit.GerritURI;
import jenkins.plugins.gerrit.PagedCodeProjectsRequest;
import jenkins.scm.api.SCMNavigator;
import jenkins.scm.api.SCMNavigatorDescriptor;
import jenkins.scm.api.SCMSourceObserver;
import jenkins.scm.api.trait.SCMNavigatorRequest;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMSourceTraitDescriptor;
import jenkins.scm.api.trait.SCMTrait;
import jenkins.scm.impl.form.NamedArrayList;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.transport.URIish;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class GerritSCMNavigator
extends SCMNavigator {
    @CheckForNull
    private String serverUrl;
    private boolean insecureHttps;
    @CheckForNull
    private String credentialsId;
    @Nonnull
    private List<? extends SCMTrait<?>> traits;

    public GerritSCMNavigator() {
        this(null, false, null, Collections.emptyList());
    }

    @DataBoundConstructor
    public GerritSCMNavigator(String serverUrl, boolean insecureHttps, String credentialsId, List<? extends SCMTrait<?>> traits) {
        this.serverUrl = StringUtils.trimToNull((String)serverUrl);
        this.insecureHttps = insecureHttps;
        this.credentialsId = StringUtils.defaultIfBlank((String)credentialsId, null);
        this.traits = Optional.ofNullable(traits).map(Collections::unmodifiableList).orElseGet(Collections::emptyList);
    }

    @Nonnull
    protected String id() {
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        attributes.put("server-url", this.serverUrl);
        attributes.put("credentials-id", this.credentialsId);
        return attributes.entrySet().stream().map(attribute -> (String)attribute.getKey() + "=" + (String)attribute.getValue()).collect(Collectors.joining("::"));
    }

    public void visitSources(@Nonnull SCMSourceObserver observer) throws IOException, InterruptedException {
        GerritApi gerritApi;
        GerritURI gerritURI;
        try {
            gerritURI = this.getGerritURI();
            gerritApi = this.createGerritApiBuilder(observer).build();
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        try (GerritSCMNavigatorRequest request = ((GerritSCMNavigatorContext)new GerritSCMNavigatorContext().withTraits(this.traits)).newRequest(this, observer);){
            SCMNavigatorRequest.SourceLambda sourceLambda = projectName -> ((GerritSCMSourceBuilder)new GerritSCMSourceBuilder(this.getId() + "::" + projectName, projectName, gerritURI, this.insecureHttps, this.credentialsId).withRequest(request)).build();
            PagedCodeProjectsRequest projectsRequest = new PagedCodeProjectsRequest(gerritApi);
            for (ProjectInfo projectInfo : projectsRequest) {
                boolean stop = request.process(projectInfo.name, sourceLambda, null, new SCMNavigatorRequest.Witness[0]);
                if (stop) {
                    break;
                }
                this.checkInterrupt();
            }
        }
    }

    private GerritApiBuilder createGerritApiBuilder(@Nonnull SCMSourceObserver observer) throws URISyntaxException {
        return new GerritApiBuilder().logger(observer.getListener().getLogger()).gerritApiUrl(this.getGerritApiURI()).insecureHttps(this.insecureHttps).credentials(this.lookupCredentials((Item)observer.getContext()));
    }

    @CheckForNull
    private StandardUsernamePasswordCredentials lookupCredentials(Item context) {
        if (this.credentialsId == null) {
            return null;
        }
        return (StandardUsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (Item)context, (Authentication)ACL.SYSTEM, (List)URIRequirementBuilder.fromUri((String)this.serverUrl).build()), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)this.credentialsId)}));
    }

    private URIish getGerritApiURI() throws URISyntaxException {
        return this.getGerritURI().getApiURI();
    }

    private GerritURI getGerritURI() throws URISyntaxException {
        return new GerritURI(new URIish(this.serverUrl));
    }

    @CheckForNull
    public String getServerUrl() {
        return this.serverUrl;
    }

    @DataBoundSetter
    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public boolean isInsecureHttps() {
        return this.insecureHttps;
    }

    @DataBoundSetter
    public void setInsecureHttps(boolean insecureHttps) {
        this.insecureHttps = insecureHttps;
    }

    @CheckForNull
    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    @Nonnull
    public List<? extends SCMTrait<?>> getTraits() {
        return this.traits;
    }

    @DataBoundSetter
    public void setTraits(List<? extends SCMTrait<?>> traits) {
        this.traits = Optional.ofNullable(traits).map(Collections::unmodifiableList).orElseGet(Collections::emptyList);
    }

    @Extension
    public static final class DescriptorImpl
    extends SCMNavigatorDescriptor {
        private final GerritSCMSource.DescriptorImpl delegate = new GerritSCMSource.DescriptorImpl();

        public String getDisplayName() {
            return "Gerrit Server";
        }

        public String getIconClassName() {
            return "icon-gerrit-logo";
        }

        public SCMNavigator newInstance(String name) {
            return new GerritSCMNavigator(null, false, null, this.delegate.getTraitsDefaults());
        }

        @NonNull
        public String getDescription() {
            return super.getDescription();
        }

        public FormValidation doCheckServerUrl(@QueryParameter String value) {
            try {
                new GerritURI(new URIish(value)).getApiURI();
            }
            catch (URISyntaxException e) {
                return FormValidation.error((String)e.getMessage());
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item context, @QueryParameter String serverUrl, @QueryParameter String credentialsId) {
            if (context == null && !Jenkins.getInstance().hasPermission(Jenkins.ADMINISTER) || context != null && !context.hasPermission(Item.EXTENDED_READ)) {
                return new StandardListBoxModel().includeCurrentValue(credentialsId);
            }
            return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(context instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)context)) : ACL.SYSTEM, context, StandardUsernameCredentials.class, URIRequirementBuilder.fromUri((String)serverUrl).build(), GitClient.CREDENTIALS_MATCHER).includeCurrentValue(credentialsId);
        }

        public List<NamedArrayList<? extends SCMSourceTraitDescriptor>> getTraitsDescriptorLists() {
            return this.delegate.getTraitsDescriptorLists();
        }

        public List<SCMSourceTrait> getTraitsDefaults() {
            return this.delegate.getTraitsDefaults();
        }
    }
}

