/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.gerrit;

import jenkins.plugins.gerrit.GerritProjectName;
import jenkins.plugins.gerrit.RefUpdateProjectName;

public class GerritProjectEvent {
    public final GerritProjectName project;
    public final RefUpdateProjectName refUpdate;
    public final String type;

    public GerritProjectEvent(GerritProjectName project, RefUpdateProjectName refUpdate, String type) {
        this.project = project;
        this.refUpdate = refUpdate;
        this.type = type;
    }

    public String getProjectName() {
        if (this.project != null) {
            return this.project.name;
        }
        if (this.refUpdate != null) {
            return this.refUpdate.project;
        }
        return null;
    }

    public String toString() {
        return "Gerrit event " + this.type + (this.getProjectName() != null ? " on project " + this.getProjectName() : "");
    }

    public boolean matches(String remoteUrl) {
        return this.getProjectName() != null && remoteUrl.replaceFirst("\\.git$", "").endsWith(this.getProjectName());
    }
}

