/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.gerrit;

import com.google.common.base.Strings;
import com.google.gerrit.extensions.common.AccountInfo;
import com.google.gerrit.extensions.common.ChangeInfo;
import com.google.gerrit.extensions.common.RevisionInfo;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.EnvironmentContributor;
import hudson.model.InvisibleAction;
import hudson.model.ItemGroup;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import jenkins.branch.BranchSource;
import jenkins.plugins.gerrit.GerritSCMSource;
import jenkins.plugins.gerrit.GerritURI;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;

@Extension
public class GerritEnvironmentContributor
extends EnvironmentContributor {
    private static final Pattern REF_PATTERN = Pattern.compile("^\\d+\\/(?<changeNum>\\d+)\\/(?<patchSet>\\d+)$");

    public void buildEnvironmentFor(@Nonnull Run r, @Nonnull EnvVars envs, @Nonnull TaskListener listener) throws IOException, InterruptedException {
        String displayName;
        Matcher matcher;
        ItemGroup jobParent = r.getParent().getParent();
        if (!(jobParent instanceof WorkflowMultiBranchProject)) {
            return;
        }
        WorkflowMultiBranchProject multiBranchProject = (WorkflowMultiBranchProject)jobParent;
        List sources = multiBranchProject.getSources();
        if (sources.isEmpty() || !(((BranchSource)sources.get(0)).getSource() instanceof GerritSCMSource)) {
            return;
        }
        WorkflowJob workflowJob = (WorkflowJob)r.getParent();
        GerritSCMSource gerritSCMSource = (GerritSCMSource)((BranchSource)multiBranchProject.getSources().get(0)).getSource();
        GerritURI gerritURI = gerritSCMSource.getGerritURI();
        envs.put("GERRIT_CREDENTIALS_ID", gerritSCMSource.getCredentialsId());
        envs.put("GERRIT_PROJECT", gerritURI.getProject());
        try {
            envs.put("GERRIT_API_URL", gerritURI.getApiURI().toString());
        }
        catch (URISyntaxException e) {
            throw new IOException("Unable to get Gerrit API URL from " + gerritURI, e);
        }
        if (Boolean.TRUE.equals(gerritSCMSource.getInsecureHttps())) {
            envs.put("GERRIT_API_INSECURE_HTTPS", "true");
        }
        if ((matcher = REF_PATTERN.matcher(displayName = workflowJob.getDisplayName())).find()) {
            Map<String, String> changeEnvs;
            int patchSetNum = Integer.parseInt(matcher.group("patchSet"));
            List changeInfos = r.getActions(ChangeInfoInvisibleAction.class);
            if (changeInfos.isEmpty()) {
                int changeNumber = Integer.parseInt(matcher.group("changeNum"));
                Optional<ChangeInfo> changeInfo = gerritSCMSource.getChangeInfo(changeNumber, gerritURI.getProject());
                ChangeInfoInvisibleAction changeInfoAction = new ChangeInfoInvisibleAction(changeInfo, patchSetNum, gerritURI);
                r.addAction((Action)changeInfoAction);
                changeEnvs = changeInfoAction.getChangeEnvs();
            } else {
                changeEnvs = ((ChangeInfoInvisibleAction)((Object)changeInfos.get(0))).getChangeEnvs();
            }
            envs.putAll(changeEnvs);
        }
    }

    private String booleanString(Boolean booleanValue) {
        return Optional.ofNullable(booleanValue).orElse(Boolean.FALSE).toString();
    }

    private String nullToEmpty(String value) {
        return Optional.ofNullable(value).orElse("");
    }

    private static String integerString(Integer integerValue) {
        return Optional.ofNullable(integerValue).map(Object::toString).orElse("");
    }

    public static class ChangeInfoInvisibleAction
    extends InvisibleAction {
        private final Map<String, String> changeEnvs = new HashMap<String, String>();

        ChangeInfoInvisibleAction(Optional<ChangeInfo> maybeChangeInfo, int patchSetNum, GerritURI gerritURI) {
            maybeChangeInfo.ifPresent(change -> {
                this.changeEnvs.put("GERRIT_CHANGE_NUMBER", Integer.toString(change._number));
                this.changeEnvs.put("GERRIT_PATCHSET_NUMBER", Integer.toString(patchSetNum));
                this.changeEnvs.put("GERRIT_CHANGE_PRIVATE_STATE", change.isPrivate != null ? Boolean.toString(change.isPrivate) : "false");
                this.changeEnvs.put("GERRIT_CHANGE_WIP_STATE", change.workInProgress != null ? Boolean.toString(change.workInProgress) : "false");
                this.changeEnvs.put("GERRIT_CHANGE_SUBJECT", change.subject);
                this.changeEnvs.put("GERRIT_CHANGE_URL", gerritURI.setPath("" + change._number).toASCIIString());
                this.changeEnvs.put("GERRIT_BRANCH", change.branch);
                this.changeEnvs.put("GERRIT_TOPIC", Strings.nullToEmpty((String)change.topic));
                this.changeEnvs.put("GERRIT_CHANGE_ID", change.id);
                this.changeEnvs.put("GERRIT_REVERTED_CHANGE_NUMBER", GerritEnvironmentContributor.integerString(change.revertOf));
                Map.Entry patchSetInfo = change.revisions.entrySet().stream().filter(entry -> ((RevisionInfo)entry.getValue())._number == patchSetNum).findFirst().get();
                this.changeEnvs.put("GERRIT_REFNAME", ((RevisionInfo)patchSetInfo.getValue()).ref);
                this.changeEnvs.put("GERRIT_REFSPEC", ((RevisionInfo)patchSetInfo.getValue()).ref);
                Optional.ofNullable(((RevisionInfo)patchSetInfo.getValue()).kind).ifPresent(kind -> this.changeEnvs.put("GERRIT_PATCHSET_KIND", kind.toString()));
                this.changeEnvs.put("GERRIT_PATCHSET_REVISION", (String)patchSetInfo.getKey());
                this.changeEnvs.put("GERRIT_CHANGE_OWNER", change.owner.name + " <" + change.owner.email + ">");
                this.changeEnvs.put("GERRIT_CHANGE_OWNER_NAME", change.owner.name);
                this.changeEnvs.put("GERRIT_CHANGE_OWNER_EMAIL", change.owner.email);
                AccountInfo uploader = ((RevisionInfo)patchSetInfo.getValue()).uploader;
                this.changeEnvs.put("GERRIT_PATCHSET_UPLOADER", uploader.name + " <" + uploader.email + ">");
                this.changeEnvs.put("GERRIT_PATCHSET_UPLOADER_NAME", uploader.name);
                this.changeEnvs.put("GERRIT_PATCHSET_UPLOADER_EMAIL", uploader.email);
            });
        }

        public Map<String, String> getChangeEnvs() {
            return this.changeEnvs;
        }
    }
}

