/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.gerrit;

import hudson.EnvVars;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.StepContext;

public class GerritChange {
    public static final Pattern BRANCH_PATTERN = Pattern.compile("[0-9][0-9]/(?<changeId>[0-9]+)/(?<revision>[0-9]+)");
    private Integer changeId = null;
    private Integer revision = null;
    private String project;

    public GerritChange(Map<String, String> env, PrintStream logger) throws IOException, InterruptedException {
        Matcher matcher;
        this.project = env.get("GERRIT_PROJECT");
        if (StringUtils.isNotEmpty((String)env.get("GERRIT_CHANGE_NUMBER"))) {
            this.changeId = Integer.parseInt(env.get("GERRIT_CHANGE_NUMBER"));
            this.revision = Integer.parseInt(env.get("GERRIT_PATCHSET_NUMBER"));
        } else if (StringUtils.isNotEmpty((String)env.get("BRANCH_NAME")) && (matcher = BRANCH_PATTERN.matcher(env.get("BRANCH_NAME"))).matches()) {
            this.changeId = Integer.parseInt(matcher.group("changeId"));
            this.revision = Integer.parseInt(matcher.group("revision"));
        }
        if (this.changeId == null && logger != null) {
            logger.println("Gerrit Review is disabled, invalid reference at BRANCH_NAME or GERRIT_CHANGE_NUMBER/GERRIT_PATCHSET_NUMBER");
        }
    }

    public GerritChange(StepContext context) throws IOException, InterruptedException {
        this((Map)context.get(EnvVars.class), ((TaskListener)context.get(TaskListener.class)).getLogger());
    }

    public boolean valid() {
        return this.changeId != null;
    }

    public Integer getChangeId() {
        return this.changeId;
    }

    public Integer getRevision() {
        return this.revision;
    }

    public String getProject() {
        return this.project;
    }
}

