/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.gerrit;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.google.common.base.Strings;
import com.google.gerrit.extensions.api.GerritApi;
import com.google.gerrit.plugins.checks.client.GerritChecksApi;
import com.google.gerrit.plugins.checks.client.GerritChecksApiBuilder;
import com.urswolfer.gerrit.client.rest.GerritAuthData;
import com.urswolfer.gerrit.client.rest.GerritRestApi;
import com.urswolfer.gerrit.client.rest.GerritRestApiFactory;
import com.urswolfer.gerrit.client.rest.http.HttpClientBuilderExtension;
import hudson.EnvVars;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import jenkins.plugins.gerrit.GerritURI;
import jenkins.plugins.gerrit.SSLNoVerifyCertificateManagerClientBuilderExtension;
import jenkins.plugins.gerrit.UserAgentClientBuilderExtension;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.transport.URIish;
import org.jenkinsci.plugins.workflow.steps.StepContext;

public class GerritApiBuilder {
    private PrintStream logger = System.out;
    private URIish gerritApiUrl;
    private Boolean insecureHttps;
    private boolean requireAuthentication;
    private String username;
    private String password;

    public GerritApiBuilder logger(PrintStream logger) {
        this.logger = logger;
        return this;
    }

    public GerritApiBuilder gerritApiUrl(URIish gerritApiUrl) {
        this.gerritApiUrl = gerritApiUrl;
        return this;
    }

    public GerritApiBuilder gerritApiUrl(String gerritApiUrl) throws URISyntaxException {
        if (gerritApiUrl == null) {
            this.gerritApiUrl = null;
        } else {
            this.gerritApiUrl(new URIish(gerritApiUrl));
        }
        return this;
    }

    public GerritApiBuilder insecureHttps(Boolean insecureHttps) {
        this.insecureHttps = insecureHttps;
        return this;
    }

    public GerritApiBuilder requireAuthentication() {
        this.requireAuthentication = true;
        return this;
    }

    public GerritApiBuilder credentials(String username, String password) {
        this.username = username;
        this.password = password;
        return this;
    }

    public GerritApiBuilder credentials(StandardUsernamePasswordCredentials credentials) {
        if (credentials != null) {
            this.username = credentials.getUsername();
            this.password = credentials.getPassword().getPlainText();
        }
        return this;
    }

    public GerritApiBuilder stepContext(StepContext context) throws URISyntaxException, IOException, InterruptedException {
        EnvVars envVars = (EnvVars)context.get(EnvVars.class);
        this.logger(((TaskListener)context.get(TaskListener.class)).getLogger());
        if (StringUtils.isNotEmpty((String)((String)envVars.get((Object)"GERRIT_API_URL")))) {
            this.gerritApiUrl((String)envVars.get((Object)"GERRIT_API_URL"));
        } else if (StringUtils.isNotEmpty((String)((String)envVars.get((Object)"GERRIT_CHANGE_URL")))) {
            this.gerritApiUrl(new GerritURI(new URIish((String)envVars.get((Object)"GERRIT_CHANGE_URL"))).getApiURI());
        }
        this.insecureHttps(Boolean.parseBoolean((String)envVars.get((Object)"GERRIT_API_INSECURE_HTTPS")));
        String credentialsId = StringUtils.defaultIfEmpty((String)((String)envVars.get((Object)"GERRIT_CREDENTIALS_ID")), null);
        if (credentialsId != null) {
            this.credentials((StandardUsernamePasswordCredentials)CredentialsProvider.findCredentialById((String)credentialsId, StandardUsernamePasswordCredentials.class, (Run)((Run)context.get(Run.class)), (DomainRequirement[])new DomainRequirement[0]));
        }
        return this;
    }

    public GerritApi build() {
        GerritRestApi gerritApi = null;
        if (this.verifyParameters()) {
            ArrayList<HttpClientBuilderExtension> extensions = new ArrayList<HttpClientBuilderExtension>();
            extensions.add(UserAgentClientBuilderExtension.INSTANCE);
            if (Boolean.TRUE.equals(this.insecureHttps)) {
                extensions.add(SSLNoVerifyCertificateManagerClientBuilderExtension.INSTANCE);
            }
            gerritApi = new GerritRestApiFactory().create((GerritAuthData)new GerritAuthData.Basic(this.gerritApiUrl.toString(), this.username, this.password, true), extensions.toArray(new HttpClientBuilderExtension[0]));
        }
        return gerritApi;
    }

    public GerritChecksApi buildChecksApi() {
        if (this.verifyParameters()) {
            GerritChecksApiBuilder gerritChecksApiBuilder = new GerritChecksApiBuilder(this.gerritApiUrl);
            if (this.username != null) {
                gerritChecksApiBuilder.setBasicAuthCredentials(this.username, this.password);
            }
            if (Boolean.TRUE.equals(this.insecureHttps)) {
                gerritChecksApiBuilder.allowInsecureHttps();
            }
            return gerritChecksApiBuilder.build();
        }
        return null;
    }

    public String toString() {
        return this.gerritApiUrl == null ? "null" : this.gerritApiUrl.toString();
    }

    private boolean verifyParameters() {
        if (this.gerritApiUrl == null) {
            this.logger.println("Gerrit Review is disabled no API URL");
            return false;
        }
        if (this.requireAuthentication && Strings.isNullOrEmpty((String)this.username)) {
            this.logger.println("Gerrit Review requires authentication, however there are no credentials defined or are empty.");
            return false;
        }
        return true;
    }
}

