/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.gerrit;

import javax.annotation.Nonnull;
import jenkins.plugins.gerrit.ChangeSCMHead;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.mixin.ChangeRequestSCMRevision;

public class ChangeSCMRevision
extends ChangeRequestSCMRevision<ChangeSCMHead> {
    private static final long serialVersionUID = 1L;
    @Nonnull
    private final String patchsetHash;
    private final boolean isFilteredByPendingChecks;

    ChangeSCMRevision(@Nonnull ChangeSCMHead head, @Nonnull String patchsetHash) {
        super((SCMHead)head, (SCMRevision)new AbstractGitSCMSource.SCMRevisionImpl(head.getTarget(), patchsetHash));
        this.patchsetHash = patchsetHash;
        this.isFilteredByPendingChecks = !head.getPendingCheckerUuids().isEmpty();
    }

    @Nonnull
    public String getPatchsetHash() {
        return this.patchsetHash;
    }

    public boolean equivalent(ChangeRequestSCMRevision<?> o) {
        if (!(o instanceof ChangeSCMRevision)) {
            return false;
        }
        ChangeSCMRevision other = (ChangeSCMRevision)o;
        if (this.isFilteredByPendingChecks) {
            return false;
        }
        return this.getHead().equals((Object)other.getHead()) && this.patchsetHash.equals(other.patchsetHash);
    }

    public int _hashCode() {
        return this.patchsetHash.hashCode();
    }

    public String toString() {
        return this.patchsetHash;
    }
}

