/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.gerrit;

import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.plugins.gerrit.Messages;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.mixin.ChangeRequestCheckoutStrategy;
import jenkins.scm.api.mixin.ChangeRequestSCMHead2;
import org.eclipse.jgit.lib.ObjectId;

public class ChangeSCMHead
extends SCMHead
implements ChangeRequestSCMHead2 {
    private static final Logger LOGGER = Logger.getLogger(ChangeSCMHead.class.getName());
    private static final long serialVersionUID = 1L;
    private final int changeNumber;
    private final int patchset;
    private final String rev;
    private final Set<String> pendingCheckerUuids;

    ChangeSCMHead(Map.Entry<String, ObjectId> ref, String branchName, Set<String> pendingCheckerUuids) {
        super(branchName);
        this.changeNumber = ChangeSCMHead.parseChangeNumber(ref);
        this.patchset = ChangeSCMHead.parsePatchset(ref);
        this.rev = ref.getValue().name();
        this.pendingCheckerUuids = pendingCheckerUuids;
    }

    private static int parseChangeNumber(Map.Entry<String, ObjectId> ref) {
        return ChangeSCMHead.parseIntPart(ref, 3);
    }

    private static int parsePatchset(Map.Entry<String, ObjectId> ref) {
        return ChangeSCMHead.parseIntPart(ref, 4);
    }

    private static int parseIntPart(Map.Entry<String, ObjectId> ref, int index) {
        String[] changeParts = ref.getKey().split("/");
        return Integer.parseInt(changeParts[index]);
    }

    public String getPronoun() {
        return Messages.ChangeSCMHead_Pronoun();
    }

    @Nonnull
    public ChangeRequestCheckoutStrategy getCheckoutStrategy() {
        return ChangeRequestCheckoutStrategy.HEAD;
    }

    @Nonnull
    public String getOriginName() {
        return this.getName();
    }

    @Nonnull
    public String getId() {
        return "C-" + this.changeNumber + "/" + this.patchset;
    }

    public int getChangeNumber() {
        return this.changeNumber;
    }

    public int getPatchSetNumber() {
        return this.patchset;
    }

    public String getRev() {
        return this.rev;
    }

    public Set<String> getPendingCheckerUuids() {
        return this.pendingCheckerUuids;
    }

    @Nonnull
    public SCMHead getTarget() {
        return new SCMHead(this.getName());
    }
}

