/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.gerrit;

import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.google.common.collect.ImmutableList;
import com.google.gerrit.extensions.api.GerritApi;
import com.google.gerrit.extensions.api.changes.Changes;
import com.google.gerrit.extensions.client.ListChangesOption;
import com.google.gerrit.extensions.common.ChangeInfo;
import com.google.gerrit.extensions.common.RevisionInfo;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.plugins.checks.api.PendingChecksInfo;
import com.google.gerrit.plugins.checks.client.GerritChecksApi;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.model.Action;
import hudson.model.Actionable;
import hudson.model.TaskListener;
import hudson.plugins.git.Branch;
import hudson.plugins.git.GitTool;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.plugins.gerrit.ChangeSCMHead;
import jenkins.plugins.gerrit.ChangeSCMRevision;
import jenkins.plugins.gerrit.FakeTaskListener;
import jenkins.plugins.gerrit.GerritApiBuilder;
import jenkins.plugins.gerrit.GerritLogo;
import jenkins.plugins.gerrit.GerritSCMSourceContext;
import jenkins.plugins.gerrit.GerritSCMSourceRequest;
import jenkins.plugins.gerrit.GerritURI;
import jenkins.plugins.gerrit.ProjectChanges;
import jenkins.plugins.gerrit.UsernamePasswordCredentialsProvider;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.plugins.git.GitRemoteHeadRefAction;
import jenkins.plugins.git.GitSCMBuilder;
import jenkins.scm.api.SCMFile;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadCategory;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMProbe;
import jenkins.scm.api.SCMProbeStat;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;
import jenkins.scm.api.SCMSourceEvent;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.api.metadata.ObjectMetadataAction;
import jenkins.scm.api.trait.SCMSourceRequest;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.jenkinsci.plugins.gitclient.FetchCommand;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;

public abstract class AbstractGerritSCMSource
extends AbstractGitSCMSource {
    public static final String R_CHANGES = "refs/changes/";
    public static final String OPEN_CHANGES_FILTER = System.getProperty("gerrit.open.changes.filter", "-age:24w");
    private static final String ORIGIN_REF_PREFIX = "origin/";
    private static final Pattern changePattern = Pattern.compile("(\\d\\d)/(\\d+)/(\\d+)");
    private transient ProjectChanges projectChanges;

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="Overridden")
    public Boolean getInsecureHttps() {
        return null;
    }

    public Optional<ChangeInfo> getChangeInfo(int changeNum, String projectName) throws IOException {
        return this.getProjectChanges().get(changeNum, projectName);
    }

    @CheckForNull
    protected SCMRevision retrieve(final @NonNull SCMHead head, @NonNull TaskListener listener) throws IOException, InterruptedException {
        return this.doRetrieve(head, new Retriever<SCMRevision>(){

            @Override
            public SCMRevision run(GitClient client, GerritSCMSourceContext context, String remoteName, Changes.QueryRequest changeQuery) throws IOException, InterruptedException {
                if (head instanceof ChangeSCMHead) {
                    return new AbstractGitSCMSource.SCMRevisionImpl(head, ((ChangeSCMHead)head).getRev());
                }
                for (Branch b : client.getRemoteBranches()) {
                    String branchName = StringUtils.removeStart((String)b.getName(), (String)(remoteName + "/"));
                    if (!branchName.equals(head.getName())) continue;
                    return new AbstractGitSCMSource.SCMRevisionImpl(head, b.getSHA1String());
                }
                return null;
            }
        }, (GerritSCMSourceContext)new GerritSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(this.getTraits()), listener, false);
    }

    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="Known non-serializable this")
    protected void retrieve(@CheckForNull SCMSourceCriteria criteria, @Nonnull SCMHeadObserver observer, @CheckForNull SCMHeadEvent<?> event, final @Nonnull TaskListener listener) throws IOException, InterruptedException {
        this.doRetrieve(null, new Retriever<Object>(){

            @Override
            public Object run(GitClient client, GerritSCMSourceContext context, String remoteName, Changes.QueryRequest changeQuery) throws IOException, InterruptedException {
                Repository repository = client.getRepository();
                try (RevWalk walk = new RevWalk(repository);
                     GerritSCMSourceRequest request = context.newRequest((SCMSource)AbstractGerritSCMSource.this, listener);){
                    if (context.wantBranches()) {
                        this.discoverBranches(repository, walk, context, request, client.getRemoteBranches().stream().collect(Collectors.toMap(branch -> branch.getName(), branch -> branch.getSHA1())));
                    }
                    if (context.wantTags()) {
                        // empty if block
                    }
                }
                return null;
            }

            private void discoverBranches(Repository repository, RevWalk walk, GerritSCMSourceContext context, GerritSCMSourceRequest request, Map<String, ObjectId> remoteReferences) throws IOException, InterruptedException {
                listener.getLogger().println("Checking " + remoteReferences.size() + " branches ...");
                Map filteredRefs = AbstractGerritSCMSource.this.filterRemoteReferences(remoteReferences);
                listener.getLogger().println("Filtered " + filteredRefs.size() + " branches ...");
                walk.setRetainBody(false);
                int branchesCount = 0;
                int changesCount = 0;
                for (Map.Entry ref : filteredRefs.entrySet()) {
                    String refKey = (String)ref.getKey();
                    if (!refKey.startsWith("refs/heads/") && !refKey.startsWith(AbstractGerritSCMSource.R_CHANGES)) continue;
                    if (refKey.startsWith(AbstractGerritSCMSource.R_CHANGES)) {
                        try {
                            if (!AbstractGerritSCMSource.this.processChangeRequest(repository, walk, request, ref, listener)) continue;
                            listener.getLogger().format("Processed %d changes (query complete)%n", changesCount);
                            return;
                        }
                        catch (Exception e) {
                            listener.getLogger().format("Unable to process %s: %s", refKey, e.toString());
                            continue;
                        }
                    }
                    if (!AbstractGerritSCMSource.this.processBranchRequest(repository, walk, request, ref, listener)) continue;
                    listener.getLogger().format("Processed %d branches (query complete)%n", branchesCount);
                    return;
                }
                listener.getLogger().format("Processed %d branches%n", branchesCount);
                listener.getLogger().format("Processed %d changes%n", changesCount);
            }
        }, (GerritSCMSourceContext)new GerritSCMSourceContext(criteria, observer).withTraits(this.getTraits()), listener, true);
    }

    @Nonnull
    protected List<Action> retrieveActions(@CheckForNull SCMSourceEvent event, @Nonnull TaskListener listener) throws IOException, InterruptedException {
        return this.doRetrieve(null, new Retriever<List<Action>>(){

            @Override
            public List<Action> run(GitClient client, GerritSCMSourceContext context, String remoteName, Changes.QueryRequest queryRequest) throws IOException, InterruptedException {
                Map symrefs = client.getRemoteSymbolicReferences(AbstractGerritSCMSource.this.getRemote(), null);
                if (symrefs.containsKey("HEAD")) {
                    String target = (String)symrefs.get("HEAD");
                    if (target.startsWith("refs/heads/")) {
                        target = target.substring("refs/heads/".length());
                    }
                    ArrayList<Action> result = new ArrayList<Action>();
                    if (StringUtils.isNotBlank((String)target)) {
                        result.add((Action)new GitRemoteHeadRefAction(AbstractGerritSCMSource.this.getRemote(), target));
                    }
                    result.add((Action)new GerritLogo());
                    return result;
                }
                return new ArrayList<Action>();
            }
        }, (GerritSCMSourceContext)new GerritSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(this.getTraits()), listener, false);
    }

    @NonNull
    protected List<Action> retrieveActions(@NonNull SCMHead head, @CheckForNull SCMHeadEvent event, @NonNull TaskListener listener) throws IOException, InterruptedException {
        List actions = this.doRetrieve(head, (client, context, remoteName, changeQuery) -> {
            SCMSourceOwner owner = this.getOwner();
            if (owner instanceof Actionable && head instanceof ChangeSCMHead) {
                Actionable actionableOwner = (Actionable)owner;
                ChangeSCMHead change = (ChangeSCMHead)head;
                String gerritBaseUrl = this.getGerritBaseUrl();
                return actionableOwner.getActions(GitRemoteHeadRefAction.class).stream().filter(action -> action.getRemote().equals(this.getRemote())).map(action -> new ObjectMetadataAction(change.getName(), change.getId(), String.format("%s%d", gerritBaseUrl, change.getChangeNumber()))).collect(Collectors.toList());
            }
            return Collections.emptyList();
        }, (GerritSCMSourceContext)new GerritSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(this.getTraits()), listener, false);
        ImmutableList.Builder resultBuilder = new ImmutableList.Builder();
        resultBuilder.addAll((Iterable)super.retrieveActions(head, event, listener));
        resultBuilder.addAll((Iterable)actions);
        return resultBuilder.build();
    }

    private String getGerritBaseUrl() throws IOException {
        try {
            return this.getGerritURI().getApiURI().toASCIIString();
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    private boolean processBranchRequest(final Repository repository, final RevWalk walk, GerritSCMSourceRequest request, final Map.Entry<String, ObjectId> ref, final TaskListener listener) throws IOException, InterruptedException {
        final String branchName = StringUtils.removeStart((String)StringUtils.removeStart((String)ref.getKey(), (String)"refs/heads/"), (String)R_CHANGES);
        return request.process(new SCMHead(branchName), (SCMSourceRequest.IntermediateLambda)new SCMSourceRequest.IntermediateLambda<ObjectId>(){

            @Nullable
            public ObjectId create() throws IOException, InterruptedException {
                listener.getLogger().println("  Checking branch " + branchName);
                return (ObjectId)ref.getValue();
            }
        }, (SCMSourceRequest.ProbeLambda)new SCMSourceRequest.ProbeLambda<SCMHead, ObjectId>(){

            @Nonnull
            public SCMSourceCriteria.Probe create(@Nonnull SCMHead head, @Nullable ObjectId revisionInfo) throws IOException, InterruptedException {
                RevCommit commit = walk.parseCommit((AnyObjectId)revisionInfo);
                final long lastModified = TimeUnit.SECONDS.toMillis(commit.getCommitTime());
                final RevTree tree = commit.getTree();
                return new SCMProbe(){

                    public void close() throws IOException {
                    }

                    public String name() {
                        return branchName;
                    }

                    public long lastModified() {
                        return lastModified;
                    }

                    @Nonnull
                    @SuppressFBWarnings(value={"NP_LOAD_OF_KNOWN_NULL_VALUE"}, justification="TreeWalk.forPath can return null, compiler generated code for try with resources handles it")
                    public SCMProbeStat stat(@Nonnull String path) throws IOException {
                        try (TreeWalk tw = TreeWalk.forPath((Repository)repository, (String)path, (RevTree)tree);){
                            if (tw == null) {
                                SCMProbeStat sCMProbeStat = SCMProbeStat.fromType((SCMFile.Type)SCMFile.Type.NONEXISTENT);
                                return sCMProbeStat;
                            }
                            FileMode fileMode = tw.getFileMode(0);
                            if (fileMode == FileMode.MISSING) {
                                SCMProbeStat sCMProbeStat = SCMProbeStat.fromType((SCMFile.Type)SCMFile.Type.NONEXISTENT);
                                return sCMProbeStat;
                            }
                            if (fileMode == FileMode.EXECUTABLE_FILE) {
                                SCMProbeStat sCMProbeStat = SCMProbeStat.fromType((SCMFile.Type)SCMFile.Type.REGULAR_FILE);
                                return sCMProbeStat;
                            }
                            if (fileMode == FileMode.REGULAR_FILE) {
                                SCMProbeStat sCMProbeStat = SCMProbeStat.fromType((SCMFile.Type)SCMFile.Type.REGULAR_FILE);
                                return sCMProbeStat;
                            }
                            if (fileMode == FileMode.SYMLINK) {
                                SCMProbeStat sCMProbeStat = SCMProbeStat.fromType((SCMFile.Type)SCMFile.Type.LINK);
                                return sCMProbeStat;
                            }
                            if (fileMode == FileMode.TREE) {
                                SCMProbeStat sCMProbeStat = SCMProbeStat.fromType((SCMFile.Type)SCMFile.Type.DIRECTORY);
                                return sCMProbeStat;
                            }
                            SCMProbeStat sCMProbeStat = SCMProbeStat.fromType((SCMFile.Type)SCMFile.Type.OTHER);
                            return sCMProbeStat;
                        }
                    }
                };
            }
        }, (SCMSourceRequest.LazyRevisionLambda)new SCMSourceRequest.LazyRevisionLambda<SCMHead, SCMRevision, ObjectId>(){

            @Nonnull
            public SCMRevision create(@Nonnull SCMHead head, @Nullable ObjectId intermediate) throws IOException, InterruptedException {
                return new AbstractGitSCMSource.SCMRevisionImpl(head, ((ObjectId)ref.getValue()).name());
            }
        }, new SCMSourceRequest.Witness[]{new SCMSourceRequest.Witness(){

            public void record(@Nonnull SCMHead head, SCMRevision revision, boolean isMatch) {
                if (isMatch) {
                    listener.getLogger().println(head.getName() + " meets the criteria");
                }
            }
        }});
    }

    private boolean processChangeRequest(final Repository repository, final RevWalk walk, GerritSCMSourceRequest request, final Map.Entry<String, ObjectId> ref, final TaskListener listener) throws IOException, InterruptedException {
        final String branchName = StringUtils.removeStart((String)ref.getKey(), (String)R_CHANGES);
        Set<String> pendingCheckerUuids = this.getPendingCheckerUuids(request, ref);
        boolean succeeded = request.process(new ChangeSCMHead(ref, branchName, pendingCheckerUuids), (SCMSourceRequest.IntermediateLambda)new SCMSourceRequest.IntermediateLambda<ObjectId>(){

            @Nullable
            public ObjectId create() throws IOException, InterruptedException {
                return (ObjectId)ref.getValue();
            }
        }, (SCMSourceRequest.ProbeLambda)new SCMSourceRequest.ProbeLambda<ChangeSCMHead, ObjectId>(){

            @Nonnull
            public SCMSourceCriteria.Probe create(@Nonnull ChangeSCMHead head, @Nullable ObjectId revisionInfo) throws IOException, InterruptedException {
                RevCommit commit = walk.parseCommit((AnyObjectId)revisionInfo);
                final long lastModified = TimeUnit.SECONDS.toMillis(commit.getCommitTime());
                final RevTree tree = commit.getTree();
                return new SCMProbe(){

                    public void close() throws IOException {
                    }

                    public String name() {
                        return branchName;
                    }

                    public long lastModified() {
                        return lastModified;
                    }

                    @Nonnull
                    @SuppressFBWarnings(value={"NP_LOAD_OF_KNOWN_NULL_VALUE"}, justification="TreeWalk.forPath can return null, compiler generated code for try with resources handles it")
                    public SCMProbeStat stat(@Nonnull String path) throws IOException {
                        try (TreeWalk tw = TreeWalk.forPath((Repository)repository, (String)path, (RevTree)tree);){
                            if (tw == null) {
                                SCMProbeStat sCMProbeStat = SCMProbeStat.fromType((SCMFile.Type)SCMFile.Type.NONEXISTENT);
                                return sCMProbeStat;
                            }
                            FileMode fileMode = tw.getFileMode(0);
                            if (fileMode == FileMode.MISSING) {
                                SCMProbeStat sCMProbeStat = SCMProbeStat.fromType((SCMFile.Type)SCMFile.Type.NONEXISTENT);
                                return sCMProbeStat;
                            }
                            if (fileMode == FileMode.EXECUTABLE_FILE) {
                                SCMProbeStat sCMProbeStat = SCMProbeStat.fromType((SCMFile.Type)SCMFile.Type.REGULAR_FILE);
                                return sCMProbeStat;
                            }
                            if (fileMode == FileMode.REGULAR_FILE) {
                                SCMProbeStat sCMProbeStat = SCMProbeStat.fromType((SCMFile.Type)SCMFile.Type.REGULAR_FILE);
                                return sCMProbeStat;
                            }
                            if (fileMode == FileMode.SYMLINK) {
                                SCMProbeStat sCMProbeStat = SCMProbeStat.fromType((SCMFile.Type)SCMFile.Type.LINK);
                                return sCMProbeStat;
                            }
                            if (fileMode == FileMode.TREE) {
                                SCMProbeStat sCMProbeStat = SCMProbeStat.fromType((SCMFile.Type)SCMFile.Type.DIRECTORY);
                                return sCMProbeStat;
                            }
                            SCMProbeStat sCMProbeStat = SCMProbeStat.fromType((SCMFile.Type)SCMFile.Type.OTHER);
                            return sCMProbeStat;
                        }
                    }
                };
            }
        }, (SCMSourceRequest.LazyRevisionLambda)new SCMSourceRequest.LazyRevisionLambda<ChangeSCMHead, SCMRevision, ObjectId>(){

            @Nonnull
            public SCMRevision create(@Nonnull ChangeSCMHead head, @Nullable ObjectId intermediate) throws IOException, InterruptedException {
                return new ChangeSCMRevision(head, ((ObjectId)ref.getValue()).toObjectId().name());
            }
        }, new SCMSourceRequest.Witness[]{new SCMSourceRequest.Witness<ChangeSCMHead, SCMRevision>(){

            public void record(@Nonnull ChangeSCMHead head, SCMRevision revision, boolean isMatch) {
                if (isMatch) {
                    listener.getLogger().println("    Met criteria");
                } else {
                    listener.getLogger().println("    Does not meet criteria");
                }
            }
        }});
        return succeeded;
    }

    private Set<String> getPendingCheckerUuids(GerritSCMSourceRequest request, Map.Entry<String, ObjectId> ref) {
        String[] refParts = ref.getKey().split("/");
        HashSet<PendingChecksInfo> pendingChecksInfos = request.getPatchsetWithPendingChecks().get(String.format("%s/%s", refParts[refParts.length - 2], refParts[refParts.length - 1]));
        if (pendingChecksInfos != null) {
            HashSet<String> pendingCheckerUuids = new HashSet<String>();
            for (PendingChecksInfo pendingChecksInfo : pendingChecksInfos) {
                if (pendingChecksInfo.pendingChecks == null) continue;
                pendingCheckerUuids.addAll(pendingChecksInfo.pendingChecks.keySet());
            }
            return pendingCheckerUuids;
        }
        return Collections.emptySet();
    }

    private Map<String, ObjectId> filterRemoteReferences(Map<String, ObjectId> gitRefs) {
        HashMap<Integer, Integer> changes = new HashMap<Integer, Integer>();
        HashMap<String, ObjectId> filteredRefs = new HashMap<String, ObjectId>();
        for (Map.Entry<String, ObjectId> entry : gitRefs.entrySet()) {
            Matcher changeMatcher = AbstractGerritSCMSource.getChangeRefMatcher(entry.getKey());
            if (changeMatcher.matches()) {
                try {
                    Integer changeNum = Integer.parseInt(changeMatcher.group(2));
                    Integer patchSet = Integer.parseInt(changeMatcher.group(3));
                    Integer latestPatchSet = (Integer)changes.get(changeNum);
                    if (latestPatchSet != null && latestPatchSet >= patchSet) continue;
                    changes.put(changeNum, patchSet);
                }
                catch (NumberFormatException changeNum) {}
                continue;
            }
            filteredRefs.put(entry.getKey().replace("origin", "refs/heads"), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : changes.entrySet()) {
            Integer changeNum = (Integer)((Object)entry.getKey());
            Integer patchSet = (Integer)entry.getValue();
            String refName = String.format("%s%02d/%d/%d", R_CHANGES, changeNum % 100, changeNum, patchSet);
            String originName = String.format("origin/%02d/%d/%d", changeNum % 100, changeNum, patchSet);
            ObjectId changeObjectId = gitRefs.get(originName);
            filteredRefs.put(refName, changeObjectId);
        }
        return filteredRefs;
    }

    private static Matcher getChangeRefMatcher(String gitRef) {
        String changeRef = gitRef.startsWith(ORIGIN_REF_PREFIX) ? gitRef.substring(ORIGIN_REF_PREFIX.length()) : gitRef;
        return changePattern.matcher(changeRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    protected <T, C extends GerritSCMSourceContext, R extends GerritSCMSourceRequest> T doRetrieve(SCMHead head, Retriever<T> retriever, @Nonnull C context, @Nonnull TaskListener listener, boolean prune) throws IOException, InterruptedException {
        boolean doPrune = prune && head == null;
        String cacheEntry = this.getCacheEntry();
        Lock cacheLock = AbstractGerritSCMSource.getCacheLock((String)cacheEntry);
        cacheLock.lock();
        try {
            List<Object> fetchRefSpecs;
            File cacheDir = AbstractGerritSCMSource.getCacheDir((String)cacheEntry);
            Git git = Git.with((TaskListener)listener, (EnvVars)new EnvVars(EnvVars.masterEnvVars)).in(cacheDir);
            GitTool tool = this.resolveGitTool(context.gitTool());
            if (tool != null) {
                git.using(tool.getGitExe());
            }
            GitClient client = git.getClient();
            client.addDefaultCredentials((StandardCredentials)this.getCredentials());
            if (!client.hasGitRepo()) {
                listener.getLogger().println("Creating git repository in " + cacheDir);
                client.init();
            }
            String remoteName = context.remoteName();
            listener.getLogger().println("Setting " + remoteName + " to " + this.getRemote());
            client.setRemoteUrl(remoteName, this.getRemote());
            listener.getLogger().println((doPrune ? "Fetching & pruning " : "Fetching ") + remoteName + "...");
            FetchCommand fetch = client.fetch_();
            if (doPrune) {
                fetch = fetch.prune();
            }
            URIish remoteURI = null;
            try {
                remoteURI = new URIish(remoteName);
            }
            catch (URISyntaxException ex) {
                listener.getLogger().println("URI syntax exception for '" + remoteName + "' " + ex);
            }
            GerritURI gerritURI = this.getGerritURI();
            GerritApi gerritApi = this.createGerritApi(listener, gerritURI);
            if (gerritApi == null) {
                throw new IllegalStateException("Invalid gerrit configuration");
            }
            Changes.QueryRequest changeQuery = this.getOpenChanges(gerritApi, gerritURI.getProject(), context.changesQueryFilter());
            listener.getLogger().println("Looking for open changes with query '" + URLDecoder.decode(changeQuery.getQuery(), StandardCharsets.UTF_8.name()) + "' ...");
            try {
                if (head == null) {
                    Stream<RefSpec> refSpecs = context.asRefSpecs().stream().filter(refSpec -> !refSpec.getSource().contains(R_CHANGES));
                    Stream<RefSpec> openChangesRefSpecs = this.changeQueryToRefSpecs(changeQuery);
                    fetchRefSpecs = Stream.concat(refSpecs, openChangesRefSpecs).collect(Collectors.toList());
                } else {
                    String headName = head.getName();
                    String refSpecPrefix = head instanceof ChangeSCMHead ? R_CHANGES : "+refs/heads/";
                    fetchRefSpecs = Arrays.asList(new RefSpec(refSpecPrefix + headName + ":refs/remotes/origin/" + headName));
                }
            }
            catch (RestApiException e) {
                throw new IOException("Unable to query Gerrit open changes", e);
            }
            if (!fetchRefSpecs.isEmpty()) {
                fetch.from(remoteURI, fetchRefSpecs).execute();
            }
            T t = retriever.run(client, context, remoteName, changeQuery);
            return t;
        }
        finally {
            cacheLock.unlock();
        }
    }

    private Stream<RefSpec> changeQueryToRefSpecs(Changes.QueryRequest changeQuery) throws RestApiException {
        return changeQuery.get().stream().map(change -> {
            String patchRef = ((RevisionInfo)change.revisions.entrySet().iterator().next().getValue()).ref;
            return new RefSpec(patchRef + ":" + patchRef.replace("refs/changes", "refs/remotes/origin"));
        });
    }

    private ProjectChanges getProjectChanges() throws IOException {
        if (this.projectChanges == null) {
            GerritURI gerritURI = this.getGerritURI();
            GerritApi gerritApi = this.createGerritApi(FakeTaskListener.INSTANCE, gerritURI);
            this.projectChanges = new ProjectChanges(gerritApi);
        }
        return this.projectChanges;
    }

    private GerritApiBuilder setupGerritApiBuilder(@Nonnull TaskListener listener, GerritURI remoteUri) throws IOException {
        try {
            UsernamePasswordCredentialsProvider.UsernamePassword credentials = new UsernamePasswordCredentialsProvider(this.getCredentials()).getUsernamePassword(remoteUri.getRemoteURI());
            return new GerritApiBuilder().logger(listener.getLogger()).gerritApiUrl(remoteUri.getApiURI()).insecureHttps(this.getInsecureHttps()).credentials(credentials.username, credentials.password);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    private GerritApi createGerritApi(@Nonnull TaskListener listener, GerritURI remoteUri) throws IOException {
        return this.setupGerritApiBuilder(listener, remoteUri).build();
    }

    protected GerritChecksApi createGerritChecksApi(@Nonnull TaskListener listener, GerritURI remoteUri) throws IOException {
        return this.setupGerritApiBuilder(listener, remoteUri).buildChecksApi();
    }

    private Changes.QueryRequest getOpenChanges(GerritApi gerritApi, String project, String changeQueryFilter) throws UnsupportedEncodingException {
        String query = "p:" + project + " status:open " + OPEN_CHANGES_FILTER + (changeQueryFilter == null ? "" : " " + changeQueryFilter);
        return gerritApi.changes().query(URLEncoder.encode(query, StandardCharsets.UTF_8.name())).withOption(ListChangesOption.CURRENT_REVISION);
    }

    public GerritURI getGerritURI() throws IOException {
        try {
            return new GerritURI(new URIish(this.getRemote()));
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    protected boolean isCategoryEnabled(@Nonnull SCMHeadCategory category) {
        return true;
    }

    protected void decorate(GitSCMBuilder<?> builder) {
        if (!AbstractGerritSCMSource.getChangeRefMatcher(builder.head().getName()).matches()) {
            return;
        }
        builder.withRefSpec(R_CHANGES + builder.head().getName() + ":refs/remotes/" + builder.remoteName() + "/" + builder.head().getName());
    }

    public static interface Retriever<T> {
        public T run(GitClient var1, GerritSCMSourceContext var2, String var3, Changes.QueryRequest var4) throws IOException, InterruptedException;
    }
}

