/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.plugins.checks.client;

import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;

class UTCTimestampTypeAdapter
extends TypeAdapter<Timestamp> {
    private final DateFormat utcDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.US);

    public UTCTimestampTypeAdapter() {
        this.utcDateFormat.setTimeZone(TimeZone.getTimeZone(ZoneOffset.UTC));
    }

    public void write(JsonWriter out, Timestamp date) throws IOException {
        if (date == null) {
            out.nullValue();
        } else {
            out.value(this.utcDateFormat.format(date));
        }
    }

    public Timestamp read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        try {
            Calendar utcCalendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            utcCalendar.setTimeInMillis(this.utcDateFormat.parse(in.nextString()).getTime());
            return Timestamp.from(utcCalendar.toInstant());
        }
        catch (ParseException e) {
            throw new JsonParseException((Throwable)e);
        }
    }
}

