/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.plugins.checks.client;

import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.plugins.checks.api.CheckState;
import com.google.gerrit.plugins.checks.api.PendingChecksInfo;
import com.google.gerrit.plugins.checks.client.AbstractEndpoint;
import com.google.gson.reflect.TypeToken;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.eclipse.jgit.transport.URIish;

public class PendingChecks
extends AbstractEndpoint {
    private static final String PENDING_CHECKS_PATH = "plugins/checks/checks.pending/";
    private HashMap<String, String> queries = new HashMap();

    public PendingChecks(URIish gerritBaseUrl, CloseableHttpClient client, boolean isAuthenticated) throws URISyntaxException {
        super(gerritBaseUrl, client, isAuthenticated);
    }

    public PendingChecks checker(String uuid) {
        this.queries.put("checker", uuid);
        return this;
    }

    public PendingChecks scheme(String scheme) {
        this.queries.put("scheme", scheme);
        return this;
    }

    public PendingChecks state(CheckState state) {
        this.queries.put("state", state.name());
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<PendingChecksInfo> list() throws RestApiException {
        try {
            HttpGet request = new HttpGet(this.buildRequestUrl());
            try (CloseableHttpResponse response = this.client.execute((HttpUriRequest)request);){
                if (response.getStatusLine().getStatusCode() == 200) {
                    List list = (List)AbstractEndpoint.JsonBodyParser.parseResponse(EntityUtils.toString((HttpEntity)response.getEntity()), new TypeToken<List<PendingChecksInfo>>(){}.getType());
                    return list;
                }
                throw new RestApiException(String.format("Request failed with status: %d", response.getStatusLine().getStatusCode()));
            }
        }
        catch (Exception e) {
            throw new RestApiException("Failed to list pending checks: ", (Throwable)e);
        }
    }

    private URI buildRequestUrl() throws URISyntaxException {
        if (!this.queries.isEmpty()) {
            StringBuffer queryString = new StringBuffer();
            for (Map.Entry<String, String> query : this.queries.entrySet()) {
                String connector = queryString.length() > 0 ? "+" : "";
                queryString.append(String.format("%s%s:%s", connector, query.getKey(), query.getValue()));
            }
            this.uriBuilder.setParameter("query", queryString.toString());
        }
        return this.uriBuilder.setPath(this.getPrefix() + PENDING_CHECKS_PATH).build();
    }
}

