/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.plugins.checks.client;

import com.google.gerrit.plugins.checks.client.GerritChecksApi;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.eclipse.jgit.transport.URIish;

public class GerritChecksApiBuilder {
    public static final Logger LOGGER = Logger.getLogger(GerritChecksApiBuilder.class.getName());
    private URIish gerritBaseURL;
    private HttpClientBuilder clientBuilder;
    private boolean isAuthenticated = false;

    public GerritChecksApiBuilder(URIish gerritBaseURL) {
        this.gerritBaseURL = gerritBaseURL;
        this.clientBuilder = HttpClientBuilder.create();
    }

    public GerritChecksApiBuilder allowInsecureHttps() {
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)new NoopHostnameVerifier());
            this.clientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf);
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            LOGGER.log(Level.WARNING, "Could not disable SSL verification.", e);
        }
        return this;
    }

    public GerritChecksApiBuilder setBasicAuthCredentials(String username, String password) {
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        UsernamePasswordCredentials auth = new UsernamePasswordCredentials(username, password);
        provider.setCredentials(AuthScope.ANY, (Credentials)auth);
        this.clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)provider);
        this.isAuthenticated = true;
        return this;
    }

    public GerritChecksApi build() {
        return new GerritChecksApi(this.gerritBaseURL, this.clientBuilder.build(), this.isAuthenticated);
    }
}

