/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.plugins.checks.client;

import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.plugins.checks.api.CheckInfo;
import com.google.gerrit.plugins.checks.api.CheckInput;
import com.google.gerrit.plugins.checks.api.RerunInput;
import com.google.gerrit.plugins.checks.client.AbstractEndpoint;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.eclipse.jgit.transport.URIish;

public class Checks
extends AbstractEndpoint {
    private int changeNumber;
    private int patchSetNumber;

    public Checks(URIish gerritBaseUrl, CloseableHttpClient client, boolean isAuthenticated) throws URISyntaxException {
        super(gerritBaseUrl, client, isAuthenticated);
    }

    public Checks change(int changeNumber) {
        this.changeNumber = changeNumber;
        return this;
    }

    public Checks patchSet(int patchSetNumber) {
        this.patchSetNumber = patchSetNumber;
        return this;
    }

    public CheckInfo create(CheckInput input) throws RestApiException {
        try {
            return this.performCreateOrUpdate(input);
        }
        catch (Exception e) {
            throw new RestApiException("Could not create check", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CheckInfo get(String checkerUuid) throws RestApiException {
        try {
            HttpGet request = new HttpGet(this.buildRequestUrl(checkerUuid));
            try (CloseableHttpResponse response = this.client.execute((HttpUriRequest)request);){
                if (response.getStatusLine().getStatusCode() == 200) {
                    CheckInfo checkInfo = (CheckInfo)AbstractEndpoint.JsonBodyParser.parseResponse(EntityUtils.toString((HttpEntity)response.getEntity()), new TypeToken<CheckInfo>(){}.getType());
                    return checkInfo;
                }
                throw new RestApiException(String.format("Request failed with status: %d", response.getStatusLine().getStatusCode()));
            }
        }
        catch (Exception e) {
            throw new RestApiException("Failed to get check info: ", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<CheckInfo> list() throws RestApiException {
        try {
            HttpGet request = new HttpGet(this.buildRequestUrl());
            try (CloseableHttpResponse response = this.client.execute((HttpUriRequest)request);){
                if (response.getStatusLine().getStatusCode() == 200) {
                    List list = (List)AbstractEndpoint.JsonBodyParser.parseResponse(EntityUtils.toString((HttpEntity)response.getEntity()), new TypeToken<List<CheckInfo>>(){}.getType());
                    return list;
                }
                throw new RestApiException(String.format("Request failed with status: %d", response.getStatusLine().getStatusCode()));
            }
        }
        catch (Exception e) {
            throw new RestApiException("Failed to list checks: ", (Throwable)e);
        }
    }

    public CheckInfo rerun(String checkerUuid) throws RestApiException {
        return this.rerun(checkerUuid, new RerunInput());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CheckInfo rerun(String checkerUuid, RerunInput input) throws RestApiException {
        try {
            HttpPost request = new HttpPost(this.buildRequestUrl(checkerUuid + "/rerun"));
            String inputString = AbstractEndpoint.JsonBodyParser.createRequestBody(input, new TypeToken<RerunInput>(){}.getType());
            request.setEntity((HttpEntity)new StringEntity(inputString));
            request.setHeader("Content-type", "application/json");
            try (CloseableHttpResponse response = this.client.execute((HttpUriRequest)request);){
                if (response.getStatusLine().getStatusCode() == 200) {
                    CheckInfo checkInfo = (CheckInfo)AbstractEndpoint.JsonBodyParser.parseResponse(EntityUtils.toString((HttpEntity)response.getEntity()), new TypeToken<CheckInfo>(){}.getType());
                    return checkInfo;
                }
                throw new RestApiException(String.format("Request failed with status: %d", response.getStatusLine().getStatusCode()));
            }
        }
        catch (Exception e) {
            throw new RestApiException("Could not rerun check", (Throwable)e);
        }
    }

    public CheckInfo update(CheckInput input) throws RestApiException {
        try {
            return this.performCreateOrUpdate(input);
        }
        catch (Exception e) {
            throw new RestApiException("Could not update check", (Throwable)e);
        }
    }

    private CheckInfo performCreateOrUpdate(CheckInput input) throws RestApiException, URISyntaxException, ParseException, IOException {
        HttpPost request = new HttpPost(this.buildRequestUrl());
        String inputString = AbstractEndpoint.JsonBodyParser.createRequestBody(input, new TypeToken<CheckInput>(){}.getType());
        request.setEntity((HttpEntity)new StringEntity(inputString));
        request.setHeader("Content-type", "application/json");
        Throwable throwable = null;
        try (CloseableHttpResponse response = this.client.execute((HttpUriRequest)request);){
            if (response.getStatusLine().getStatusCode() == 200) {
                CheckInfo checkInfo = (CheckInfo)AbstractEndpoint.JsonBodyParser.parseResponse(EntityUtils.toString((HttpEntity)response.getEntity()), new TypeToken<CheckInfo>(){}.getType());
                return checkInfo;
            }
            try {
                throw new RestApiException(String.format("POST %s with body '%s' returned status %d (%s)", request.getURI(), inputString, response.getStatusLine().getStatusCode(), EntityUtils.toString((HttpEntity)response.getEntity())));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private URI buildRequestUrl() throws URISyntaxException {
        return this.buildRequestUrl("");
    }

    private URI buildRequestUrl(String suffixPath) throws URISyntaxException {
        return this.uriBuilder.setPath(String.format("%schanges/%d/revisions/%d/checks/%s", this.getPrefix(), this.changeNumber, this.patchSetNumber, suffixPath)).build();
    }
}

